% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{rfacts_paths}
\alias{rfacts_paths}
\title{Read paths to rfacts system dependencies}
\usage{
rfacts_paths()
}
\value{
A data frame with paths and other metadata about \code{rfacts}
system dependencies
}
\description{
Read the file specified by the \code{RFACTS_PATHS}
environment variable.
}
\section{Dependencies}{

\code{rfacts} has strict system requirements, and the installations
vary from system to system. You need to specify the locations of
system executables in a CSV file that lists the path and metadata
of each executable. This file must have one row per executable
and the following columns.
\itemize{
\item \code{executable_type}: Must be "mono", "flfll", or "engine" to
denote the general type of the executable.
\item \code{facts_version}: The version of FACTS with which this executable
is compatible.
\item \code{path}: File path to the executable.
\item \code{engine_name}: For engines only. Name of the engine.
Must be one of the engine types in the example CSV file at
\code{system.file("example_paths.csv", package = "rfacts")}.
\item \code{param_set}: For engines only. Parameter set designation listed in the
XML code of FACTS files for that engine. See
\code{system.file("example_paths.csv", package = "rfacts")}
for examples.
\item \code{param_type}: For engines only. Parameter type designation listed in the
XML code of FACTS files for that engine. See
\code{system.file("example_paths.csv", package = "rfacts")}
for examples.
}

When you call a trial simulation function in \code{rfacts},
the package automatically reads this file
and memorizes the contents for later use. The file at
\code{system.file("example_paths.csv", package = "rfacts")}
(\code{inst/example_paths.csv} in the package source.)
has an example of such a file. All the columns in that file
are required, and you may, remove, or modify rows to fit
your specific system.

To enable \code{rfacts} to find this CSV file, you need to
set the \code{RFACTS_PATHS} environment variable to the
path to this file. The easiest way to do this is call
\code{usethis::edit_r_environ()} to edit your \code{.Renviron} file
and then add a new line with something like
\verb{RFACTS_PATHS=/path/to/file/paths.csv}. Then,
restart your R session and call \code{Sys.getenv("RFACTS_PATHS")}
to verify that this environment variable was set correctly.

The \code{rfacts_sitrep()} function inspects the current system dependency
info and ensures each executable exists and has the correct permissions.

If you change the \code{RFACTS_PATHS} environment variable,
you need to call \code{\link[=reset_rfacts_paths]{reset_rfacts_paths()}} or restart R
for the changes to take effect.
}

\examples{
# Can only run if system dependencies are configured:
if (file.exists(Sys.getenv("RFACTS_PATHS"))) {
rfacts_paths()
}
}
\seealso{
rfacts_sitrep
}
