/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.values;

import java.util.OptionalInt;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.variables.IntVar;

public final class IntDomainLast
implements IntValueSelector,
Function<IntVar, OptionalInt> {
    private final Solution lastSolution;
    private final IntValueSelector mainSelector;
    private final BiPredicate<IntVar, Integer> condition;

    public IntDomainLast(Solution solution, IntValueSelector mainSelector, BiPredicate<IntVar, Integer> condition) {
        this.lastSolution = solution;
        this.mainSelector = mainSelector;
        this.condition = condition == null ? (var, val) -> true : condition;
    }

    @Override
    public int selectValue(IntVar var) {
        int value;
        if (this.lastSolution.exists() && this.relevant(var, value = this.lastSolution.getIntVal(var)) && this.condition.test(var, value)) {
            return value;
        }
        return this.mainSelector.selectValue(var);
    }

    @Override
    public OptionalInt apply(IntVar var) {
        int value;
        if (this.lastSolution.exists() && this.relevant(var, value = this.lastSolution.getIntVal(var)) && this.condition.test(var, value)) {
            return OptionalInt.of(value);
        }
        return OptionalInt.empty();
    }

    private boolean relevant(IntVar var, int value) {
        return var.hasEnumeratedDomain() && var.contains(value) || !var.hasEnumeratedDomain() && (var.getLB() == value || var.getUB() == value);
    }
}

