/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import java.util.Arrays;
import java.util.Comparator;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;

public class TuplesList
extends LargeRelation {
    protected final int[][] tuplesIndexes;
    protected static final Comparator<int[]> TCOMP = (o1, o2) -> {
        int i;
        int n = ((int[])o1).length;
        for (i = 0; i < n && o1[i] == o2[i]; ++i) {
        }
        if (i == n) {
            return 0;
        }
        if (o1[i] < o2[i]) {
            return -1;
        }
        return 1;
    };

    TuplesList(int[][] tuplesIndexes) {
        this.tuplesIndexes = tuplesIndexes;
        Arrays.sort(tuplesIndexes, TCOMP);
    }

    public TuplesList(Tuples tuples, IntVar[] vars) {
        int nb = tuples.nbTuples();
        int[][] _tuplesIndexes = new int[nb][];
        int k = 0;
        for (int i = 0; i < nb; ++i) {
            int[] tuple = tuples.get(i);
            if (!this.valid(tuple, vars)) continue;
            _tuplesIndexes[k++] = tuple;
        }
        this.tuplesIndexes = new int[k][];
        System.arraycopy(_tuplesIndexes, 0, this.tuplesIndexes, 0, k);
        Arrays.sort(this.tuplesIndexes, TCOMP);
    }

    public int[] getTuple(int support) {
        return this.tuplesIndexes[support];
    }

    public int[][] getTupleTable() {
        return this.tuplesIndexes;
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        throw new SolverException("TuplesList is an unusual large relation...");
    }

    @Override
    public boolean isConsistent(int[] tuple) {
        return Arrays.binarySearch(this.tuplesIndexes, tuple, TCOMP) >= 0;
    }

    @Override
    public Tuples convert() {
        Tuples tuples = new Tuples(true);
        for (int[] t : this.tuplesIndexes) {
            tuples.add(t);
        }
        return tuples;
    }
}

