/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.CouplesTable;
import org.chocosolver.solver.constraints.extension.binary.PropBinCSP;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

public class PropBinFC
extends PropBinCSP {
    private final IntIterableBitSet vrms = new IntIterableBitSet();

    public PropBinFC(IntVar x, IntVar y, Tuples tuples) {
        this(x, y, new CouplesTable(tuples, x, y));
    }

    private PropBinFC(IntVar x, IntVar y, CouplesTable table) {
        super(x, y, table);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.v0.isInstantiated()) {
            this.onInstantiation0();
        }
        if (this.v1.isInstantiated()) {
            this.onInstantiation1();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.onInstantiation0();
        } else {
            this.onInstantiation1();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInstantiation0() throws ContradictionException {
        int value = this.v0.getValue();
        DisposableValueIterator values = this.v1.getValueIterator(true);
        this.vrms.clear();
        this.vrms.setOffset(this.v1.getLB());
        try {
            while (values.hasNext()) {
                int val = values.next();
                if (this.relation.isConsistent(value, val)) continue;
                this.vrms.add(val);
            }
            this.v1.removeValues(this.vrms, this);
        }
        finally {
            values.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInstantiation1() throws ContradictionException {
        int value = this.v1.getValue();
        DisposableValueIterator values = this.v0.getValueIterator(true);
        this.vrms.clear();
        this.vrms.setOffset(this.v0.getLB());
        try {
            while (values.hasNext()) {
                int val = values.next();
                if (this.relation.isConsistent(val, value)) continue;
                this.vrms.add(val);
            }
            this.v0.removeValues(this.vrms, this);
        }
        finally {
            values.dispose();
        }
    }
}

