% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_binomial.R
\name{dist_binomial}
\alias{dist_binomial}
\title{Binomial Distribution}
\usage{
dist_binomial(size = NULL, prob = NULL)
}
\arguments{
\item{size}{Number of trials parameter (integer), or \code{NULL} as a placeholder.}

\item{prob}{Success probability parameter, or \code{NULL} as a placeholder.}
}
\value{
A \code{BinomialDistribution} object.
}
\description{
See \link[stats:Binomial]{stats::Binomial}
}
\details{
Both parameters can be overridden with
\code{with_params = list(size = ..., prob = ...)}.
}
\examples{
d_binom <- dist_binomial(size = 10, prob = 0.5)
x <- d_binom$sample(100)
d_emp <- dist_empirical(x)

plot_distributions(
  empirical = d_emp,
  theoretical = d_binom,
  estimated = d_binom,
  with_params = list(
    estimated = list(
      size = max(x),
      prob = mean(x) / max(x)
    )
  ),
  .x = 0:max(x)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
