% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_bdegp.R
\name{dist_bdegp}
\alias{dist_bdegp}
\title{Construct a BDEGP-Family}
\usage{
dist_bdegp(n, m, u, epsilon)
}
\arguments{
\item{n}{Number of dirac components, starting with a point mass at 0.}

\item{m}{Number of erlang components, translated by \code{n - 0.5}.}

\item{u}{Blending cut-off, must be a positive real.}

\item{epsilon}{Blending radius, must be a positive real less than \code{u}.
The blending interval will be \verb{u - epsilon < x < u + epsilon}.}
}
\value{
\itemize{
\item A \code{MixtureDistribution} of
\itemize{
\item \code{n} \code{DiracDistribution}s at 0 .. n - 1 and
\item a \code{BlendedDistribution} object with child Distributions
\itemize{
\item a \code{TranslatedDistribution} with offset \code{n - 0.5} of an \code{ErlangMixtureDistribution} with \code{m} shapes
\item and a \code{GeneralizedParetoDistribution} with shape parameter restricted to [0, 1] and location parameter fixed
at \code{u}
With break \code{u} and bandwidth \code{epsilon}.
}
}
}
}
\description{
Constructs a BDEGP-Family distribution with fixed number of components and
blending interval.
}
\examples{
dist <- dist_bdegp(n = 1, m = 2, u = 10, epsilon = 3)
params <- list(
  dists = list(
    list(),
    list(
      dists = list(
        list(
          dist = list(
            shapes = list(1L, 2L),
            scale = 1.0,
            probs = list(0.7, 0.3)
          )
        ),
        list(
          sigmau = 1.0,
          xi = 0.1
        )
      ),
      probs = list(0.1, 0.9)
    )
  ),
  probs = list(0.95, 0.05)
)
x <- dist$sample(100, with_params = params)

plot_distributions(
  theoretical = dist,
  empirical = dist_empirical(x),
  .x = seq(0, 20, length.out = 101),
  with_params = list(theoretical = params)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_lognormal}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
