% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\docType{methods}
\name{.prepareOutput}
\alias{.prepareOutput}
\alias{.prepareOutput,RasterLayer-method}
\alias{.prepareOutput,ANY-method}
\title{Make any modifications to object recovered from cacheRepo}
\usage{
.prepareOutput(object, cacheRepo, ...)

\S4method{.prepareOutput}{RasterLayer}(object, cacheRepo, ...)

\S4method{.prepareOutput}{ANY}(object, cacheRepo, ...)
}
\arguments{
\item{object}{Any R object}

\item{cacheRepo}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{...}{Arguments of \code{FUN} function .}
}
\value{
The object, modified
}
\description{
This is a generic definition that can be extended according to class.
}
\examples{
a <- 1
.prepareOutput(a) # does nothing

b <- "Null"
.prepareOutput(b) # converts to NULL

# For rasters, it is same as .prepareFileBackedRaster
try(archivist::createLocalRepo(tempdir()))

library(raster)
r <- raster(extent(0,10,0,10), vals = 1:100)

# write to disk manually -- will be in tempdir()
r <- writeRaster(r, file = tempfile())

# copy it to the cache repository
r <- .prepareOutput(r, tempdir())
}
\author{
Eliot McIntire
}
