% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud.R
\name{cloudDownload}
\alias{cloudDownload}
\title{Download from cloud, if necessary}
\usage{
cloudDownload(outputHash, newFileName, gdriveLs, cacheRepo, cloudFolderID)
}
\arguments{
\item{outputHash}{The \code{cacheId} of the object to upload}

\item{newFileName}{The character string of the local filename that the downloaded object will have}

\item{gdriveLs}{The result of \code{googledrive::drive_ls(as_id(cloudFolderID), pattern = "outputHash")}}

\item{cacheRepo}{A repository used for storing cached objects.
This is optional if \code{Cache} is used inside a SpaDES module.}

\item{cloudFolderID}{A googledrive id of a folder, e.g., using \code{drive_mkdir()}.
If left as \code{NULL}, the function will create a cloud folder with a warning.
The warning will have the \code{cloudFolderID} that should be used in subsequent calls.
It will also be added to \code{options("reproducible.cloudFolderID")},
but this will not persist across sessions.}
}
\description{
Meant for internal use, as there are internal objects as arguments.
}
