% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_citation.R
\name{format_citation}
\alias{format_citation}
\alias{cite_citation}
\alias{clean_citation}
\title{Citation formatting}
\usage{
format_citation(citation, authorsdate = FALSE, short = FALSE, intext = FALSE)

cite_citation(citation)

clean_citation(citation)
}
\arguments{
\item{citation}{A character string of a citation.}

\item{authorsdate}{Only show authors and date (remove title, journal, etc.).}

\item{short}{If more than one authors, replace by \verb{et al.}}

\item{intext}{Remove brackets around the date (so that it can be placed
inside larger parentheses).}
}
\value{
A character string.
}
\description{
Convenience functions to manipulate and format citations. Only works with APA
formatted citations, for now.
}
\examples{
library(report)

citation <- "Makowski, D., Ben-Shachar, M. S., Patil, I., & Ludecke, D. (2020).
Methods and Algorithms for Correlation Analysis in R. Journal of Open Source
Software, 5(51), 2306."

format_citation(citation, authorsdate = TRUE)
format_citation(citation, authorsdate = TRUE, short = TRUE)
format_citation(citation, authorsdate = TRUE, short = TRUE, intext = TRUE)

cite_citation(citation)
clean_citation(citation())
}
