% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydrate.R
\name{hydrate}
\alias{hydrate}
\title{Copy packages from user libraries to a project library}
\usage{
hydrate(
  packages = NULL,
  ...,
  library = NULL,
  repos = getOption("repos"),
  update = FALSE,
  sources = NULL,
  prompt = interactive(),
  report = TRUE,
  project = NULL
)
}
\arguments{
\item{packages}{The set of \R packages to install. When \code{NULL}, the
packages found by \code{\link[=dependencies]{dependencies()}} are used.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{library}{The \R library to be hydrated. When \code{NULL}, the active
library as reported by \code{.libPaths()} is used.}

\item{repos}{The \R repositories to be used. If the project depends on any
\R packages which cannot be found within the user library paths, then
those packages will be installed from these repositories instead.}

\item{update}{Boolean; should \code{hydrate()} attempt to update already-installed
packages if the requested package is already installed in the project
library? Set this to \code{"all"} if you'd like \emph{all} packages to be refreshed
from the source library if possible.}

\item{sources}{A vector of library paths where renv should look for packages.
When \code{NULL} (the default), \code{hydrate()} will look in the system libraries
(the user library, the site library and the default library) then the
renv cache.

If a package is not found in any of these locations, \code{hydrate()}
will try to install it from the active R repositories.}

\item{prompt}{Boolean; prompt the user before taking any action? Ignored
when \code{report = FALSE}.}

\item{report}{Boolean; display a report of what packages will be installed
by \code{renv::hydrate()}?}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A named \R list, giving the packages that were used for hydration
as well as the set of packages which were not found.
}
\description{
\code{hydrate()} installs missing packages from a user library into the project
library. \code{hydrate()} is called automatically by \code{\link[=init]{init()}}, and it is rare
that you should need it otherwise, as it can easily get your project into
an inconsistent state.

It may very occasionally be useful to call \code{hydate(update = "all")} if you
want to update project packages to match those installed in your global
library (as opposed to using \code{\link[=update]{update()}} which will get the latest versions
from CRAN). In this case, you should verify that your code continues to work,
then call \code{\link[=snapshot]{snapshot()}} to record updated package versions in the lockfile.
}
\examples{
\dontrun{

# hydrate the active library
renv::hydrate()

}
}
\keyword{internal}
