% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\docType{data}
\name{settings}
\alias{settings}
\title{Project Settings}
\format{
An object of class \code{list} of length 6.
}
\usage{
settings
}
\description{
Define project-local settings that can be used to adjust the behavior of
\code{renv} with your particular project.
}
\section{Settings}{


\describe{

\item{\code{external.libraries}}{

A vector of library paths, to be used in addition to the project's own
private library. This can be useful if you have a package available for use
in some global library, but for some reason \code{renv} is not able to install
that package (e.g. sources or binaries for that package are not publicly
available, or you have been unable to orchestrate the pre-requisites for
installing some packages from source on your machine).

}

\item{\code{ignored.packages}}{

A vector of packages, which should be ignored when attempting to snapshot
the project's private library. Note that if a package has already been
added to the lockfile, that entry in the lockfile will not be ignored.

}

\item{\code{package.dependency.fields}}{

During dependency discovery, \code{renv} uses the fields of an installed
package's \code{DESCRIPTION} file to determine that package's recursive
dependencies. By default, the \code{Imports}, \code{Depends} and \code{LinkingTo} fields
are used. If you'd prefer that \code{renv} also captures the \code{Suggests}
dependencies for a package, you can set this to
\code{c("Imports", "Depends", "LinkingTo", "Suggests")}.

}

\item{\code{snapshot.type}}{

The type of snapshot to perform by default. See \link{snapshot} for more
details.

}

\item{\code{use.cache}}{

Use a global cache of \R packages. When active, \code{renv} will install
packages into a global cache, and link packages from the cache into your
\code{renv} projects as appropriate. This can greatly save on disk space
and install time when for \R packages which are used across multiple
projects in the same environment.

}

\item{\code{vcs.ignore.library}}{

Set whether the \code{renv} project library is excluded from version control.

}

}
}

\section{Defaults}{


You can change the default values of these settings for newly-created \code{renv}
projects by setting \R options for \code{renv.settings} or \verb{renv.settings.<name>}.
For example:

\preformatted{
options(renv.settings = list(snapshot.type = "all"))
options(renv.settings.snapshot.type = "all")
}

If both of the \code{renv.settings} and \verb{renv.settings.<name>} options are set
for a particular key, the option associated with \verb{renv.settings.<name>} is
used instead. We recommend setting these in an appropriate startup profile,
e.g. \verb{~/.Rprofile} or similar.
}

\examples{

\dontrun{

# view currently-ignored packaged
renv::settings$ignored.packages()

# ignore a set of packages
renv::settings$ignored.packages("devtools", persist = FALSE)

}
}
\keyword{datasets}
