% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{tie}
\alias{tie}
\alias{dyad}
\title{tie}
\usage{
tie(variable, attr_dyads = NULL, scaling = c("none", "std"), x, variableName)
}
\arguments{
\item{variable}{A string specifying the attribute to compute the statistic. If \code{attr_dyads} is a \code{data.frame}, this refers to the column name in \code{attr_actors}. If \code{attr_dyads} is a \code{matrix}, this corresponds to the name of the exogenous attribute, used to label the statistic in the resulting \code{remstats} object.}

\item{attr_dyads}{A \code{data.frame} or \code{matrix} containing attribute information for dyads. If \code{attr_dyads} is a \code{data.frame}, the first two columns should represent "actor1" and "actor2" (for directed events, "actor1" corresponds to the sender, and "actor2" corresponds to the receiver). Additional columns can represent dyads' exogenous attributes. If attributes vary over time, include a column named "time". If \code{attr_dyads} is a \code{matrix}, the rows correspond to "actor1", columns to "actor2", and cells contain dyads' exogenous attributes.}

\item{scaling}{The method for scaling the statistic. The default is no scaling. Alternatively, standardization of the statistic per time point can be requested with "std".}

\item{x}{Deprecated argument. Please use 'attr_dyads' instead.}

\item{variableName}{Deprecated argument. Please use 'variable' instead.}
}
\value{
List with all information required by `remstats::remstats()` to compute the statistic.
}
\description{
Specifies the statistic for a "tie" (or, "dyad") effect.
}
\details{
The "tie" effect or "dyad" effect refers to an exogenous dyad attribute that influences dyad \emph{(i,j)}'s interaction rate (in tie-oriented models) or the probability of actor \emph{j} being chosen as a receiver for the event sent by the active sender \emph{i} (in actor-oriented models). The statistic represents the value of the exogenous attribute for dyad \emph{(i,j)} in the \code{attr_dyads} data.
}
\examples{
data(history)
data(both_male_long)
effect <- ~ tie(variable = "both_male", attr_dyads = both_male_long)
reh <- remify::remify(history, model = "tie")
remstats(reh = reh, tie_effects = effect)

data(both_male_wide)
effect <- ~ tie(variable = "both_male", attr_dyads = both_male_wide)
reh <- remify::remify(history, model = "tie")
remstats(reh = reh, tie_effects = effect)

}
