% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_randomize.R
\name{nice_randomize}
\alias{nice_randomize}
\title{Easily randomization}
\usage{
nice_randomize(
  design = "between",
  Ncondition = 3,
  n = 9,
  condition.names = c("a", "b", "c"),
  col.names = c("id", "Condition")
)
}
\arguments{
\item{design}{The design: either between-subject (different groups)
or within-subject (repeated-measures on same people).}

\item{Ncondition}{The number of conditions you want to randomize.}

\item{n}{The desired sample size. Note that it needs to
be a multiple of your number of groups if you are using\code{between}.}

\item{condition.names}{The names of the randomized conditions.}

\item{col.names}{The desired additional column names for a runsheet.}
}
\value{
A dataframe, with participant ID and randomized condition, based
on selected design.
}
\description{
Randomize easily with different designs.
}
\examples{
# Specify design, number of conditions, number of
# participants, and names of conditions:
nice_randomize(
  design = "between", Ncondition = 4, n = 8,
  condition.names = c("BP", "CX", "PZ", "ZL")
)

# Within-Group Design
nice_randomize(
  design = "within", Ncondition = 4, n = 6,
  condition.names = c("SV", "AV", "ST", "AT")
)

# Make a quick runsheet
randomized <- nice_randomize(
  design = "within", Ncondition = 4, n = 128,
  condition.names = c("SV", "AV", "ST", "AT"),
  col.names = c(
    "id", "Condition", "Date/Time",
    "SONA ID", "Age/Gd.", "Handedness",
    "Tester", "Notes"
  )
)
head(randomized)

}
\seealso{
Tutorial: \url{https://rempsyc.remi-theriault.com/articles/randomize}
}
\keyword{allocation}
\keyword{conditions}
\keyword{design}
\keyword{experimental}
\keyword{random}
\keyword{randomization}
