% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWeights.R
\name{getWeights}
\alias{getWeights}
\title{Calculate weights from latitude}
\usage{
getWeights(x, f = function(x) cos(x), ...)
}
\arguments{
\item{x}{a Raster* object}

\item{f}{a function to be used to the weighting.
Defaults to \code{cos(x)}}

\item{...}{additional arguments to be passed to f}
}
\value{
a numeric vector of weights
}
\description{
Calculate weights using the cosine of latitude to compensate for area 
distortion of non-projected lat/lon data
}
\examples{
data("australiaGPCP")
wghts <- getWeights(australiaGPCP)
wghts_rst <- australiaGPCP[[1]]
wghts_rst[] <- wghts

opar <- par(mfrow = c(1,2))
plot(australiaGPCP[[1]], main = "data")
plot(wghts_rst, main = "weights")
par(opar)

}

