% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_MIdata.R
\name{extract_MIdata}
\alias{extract_MIdata}
\title{Extract a specified number of multiple imputed datasets}
\usage{
extract_MIdata(object, method = c("MAR", "J2R", "CR", "delta"), delta = 0,
  mi.setting = NULL, M = 10, minspace = 2, mess = FALSE)
}
\arguments{
\item{object}{object inheriting from class 'remoid'}

\item{method}{a method for obtaining multiple-imputed dataset. Options include
\code{MAR}, \code{J2R}, \code{CR}, and \code{delta} adjustment.
Default is MAR.}

\item{delta}{specific value used for Delta adjustment, applicable only
for method="delta".}

\item{mi.setting}{a list of arguments related to multiple imputation, including
trtvar, algorithm, method, include, exclude_chains, thin, start,
end, and seed.}

\item{M}{number of imputed datasets}

\item{minspace}{minimum number of iterations between iterations to be chosen
as imputed values (to prevent strong correlation between
imputed datasets in the case of high autocorrelation of the
MCMC chains).}

\item{mess}{logical; should messages be given? Default is TRUE.}
}
\value{
A \code{data.frame} in which the imputed datasets are stacked onto
each other.
}
\description{
Extract a specified number of multiple imputed datasets
}
\examples{
\donttest{
# data(schizow)

test = remiod(formula = y6 ~ tx + y0 + y1 + y3, data = schizow,
              trtvar = 'tx', algorithm = 'jags', method="MAR",
              ord_cov_dummy = FALSE, n.adapt = 10, n.chains = 1,
              n.iter = 100, thin = 2, warn = FALSE, seed = 1234)

extdt = extract_MIdata(object=test, method="J2R",mi.setting=NULL, M=10, minspace=2)

}
}
