% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap.R
\name{predict.remap}
\alias{predict.remap}
\title{Make predictions given a set of data and smooths predictions at region borders.
If an observation is outside of all regions and smoothing distances, the
closest region will be used to predict.}
\usage{
\method{predict}{remap}(
  object,
  data,
  smooth,
  distances,
  cores = 1,
  progress = FALSE,
  se = FALSE,
  ...
)
}
\arguments{
\item{object}{\emph{} S3 object output from remap.}

\item{data}{An sf dataframe with point geometry.}

\item{smooth}{The distance in km within a region where a smooth transition
to the next region starts. If smooth = 0, no smoothing occurs between regions
unless an observation falls on the border of two or more polygons. (Can be a
named vector with different values for each unique object$region_id' in '
object$region'.)}

\item{distances}{An optional matrix of distances between 'data' and
'object$regions' generated by \code{redist()} function (calculated
internally if not provided).}

\item{cores}{Number of cores for parallel computing. 'cores' above
default of 1 will require more memory.}

\item{progress}{If TRUE, a text progress bar is printed to the console.
(Progress bar only appears if 'cores' = 1.)}

\item{se}{If TRUE, predicted values are assumed to be standard errors and
an upper bound of combined model standard errors are calculated at each
prediction location. Should stay FALSE unless predicted values from remap are
standard error values.}

\item{...}{Arguments to pass to individual model prediction functions.}
}
\value{
Predictions in the form of a numeric vector. If se is TRUE,
upper bound for combined standard errors in the form of a numeric vector.
}
\description{
Make predictions given a set of data and smooths predictions at region borders.
If an observation is outside of all regions and smoothing distances, the
closest region will be used to predict.
}
\seealso{
\code{\link{remap}} building a regional model.
}
