# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculates the objective function values.
#'
#' @param ImpCov expected covariance matrix.
#' @param SampCov Sample covariance matrix.
#' @param type2 penalty type.
#' @param lambda penalty value.
#' @param gamma additional penalty for mcp and scad
#' @param pen_vec vector of penalized parameters.
#' @param pen_diff Vector of values to take deviation from.
#' @param e_alpha Alpha for elastic net
#'
rcpp_fit_fun <- function(ImpCov, SampCov, type2, lambda, gamma, pen_vec, pen_diff, e_alpha) {
    .Call(`_regsem_rcpp_fit_fun`, ImpCov, SampCov, type2, lambda, gamma, pen_vec, pen_diff, e_alpha)
}

#' Calculates the gradient vector based on Von Oertzen \& Brick, 2014
#'
#' @param par vector with parameters.
#' @param ImpCov expected covariance matrix.
#' @param SampCov Sample covariance matrix.
#' @param Areg A matrix with current parameter estimates.
#' @param Sreg S matrix with current parameter estimates.
#' @param A A matrix with parameter labels.
#' @param S S matrix with parameter labels.
#' @param F F matrix.
#' @param lambda penalty value.
#' @param type2 penalty type.
#' @param pen_vec parameter indicators to be penalized.
#' @param diff_par parameter values to take deviations from.
#'
rcpp_grad_ram <- function(par, ImpCov, SampCov, Areg, Sreg, A, S, F, lambda, type2, pen_vec, diff_par) {
    .Call(`_regsem_rcpp_grad_ram`, par, ImpCov, SampCov, Areg, Sreg, A, S, F, lambda, type2, pen_vec, diff_par)
}

#' Compute quasi Hessian
#'
#' @param I identity matrix.
#' @param s s vector.
#' @param y y vector.
#' @param H previous Hessian.
rcpp_quasi_calc <- function(I, s, y, H) {
    .Call(`_regsem_rcpp_quasi_calc`, I, s, y, H)
}

#' Take RAM matrices, multiplies, and returns Implied Covariance matrix.
#'
#' @param par parameter estimates.
#' @param A A matrix with parameter labels.
#' @param S S matrix with parameter labels.
#' @param S_fixed S matrix with fixed indicators.
#' @param A_fixed A matrix with fixed indicators.
#' @param A_est A matrix with parameter estimates.
#' @param S_est S matrix with parameter estimates.
#' @param F F matrix.
#' @param I Diagonal matrix of ones.
#'
#'
rcpp_RAMmult <- function(par, A, S, S_fixed, A_fixed, A_est, S_est, F, I) {
    .Call(`_regsem_rcpp_RAMmult`, par, A, S, S_fixed, A_fixed, A_est, S_est, F, I)
}

