% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfpca.face.R
\name{mfpca.face}
\alias{mfpca.face}
\title{Multilevel functional principal components analysis with fast covariance estimation}
\usage{
mfpca.face(
  Y,
  id,
  visit = NULL,
  twoway = TRUE,
  weight = "obs",
  argvals = NULL,
  pve = 0.99,
  npc = NULL,
  p = 3,
  m = 2,
  knots = 35,
  silent = TRUE
)
}
\arguments{
\item{Y}{A multilevel functional dataset on a regular grid stored in a matrix.
Each row of the data is the functional observations at one visit for one subject.
Missingness is allowed and need to be labeled as NA. The data must be specified.}

\item{id}{A vector containing the id information to identify the subjects. The
data must be specified.}

\item{visit}{A vector containing information used to identify the visits. 
If not provided, assume the visit id are 1,2,... for each subject.}

\item{twoway}{Logical, indicating whether to carry out twoway ANOVA and 
calculate visit-specific means. Defaults to \code{TRUE}.}

\item{weight}{The way of calculating covariance. \code{weight = "obs"} indicates
that the sample covariance is weighted by observations. \code{weight = "subj"} 
indicates that the sample covariance is weighted equally by subjects. Defaults to \code{"obs"}.}

\item{argvals}{A vector containing observed locations on the functional domain.}

\item{pve}{Proportion of variance explained. This value is used to choose the 
number of principal components for both levels.}

\item{npc}{Pre-specified value for the number of principal components. 
If given, this overrides \code{pve}.}

\item{p}{The degree of B-splines functions to use. Defaults to 3.}

\item{m}{The order of difference penalty to use. Defaults to 2.}

\item{knots}{Number of knots to use or the vectors of knots. Defaults to 35.}

\item{silent}{Logical, indicating whether to not display the name of each step.
Defaults to \code{TRUE}.}
}
\value{
A list containing:
\item{Xhat}{FPC approximation (projection onto leading components)
of \code{Y}, estimated curves for all subjects and visits}
\item{Xhat.subject}{Estimated subject specific curves for all subjects}
\item{Y}{The observed data}
\item{mu}{estimated mean function (or a vector of zeroes if \code{center==FALSE}).} 
\item{eta}{The estimated visit specific shifts from overall mean.}
\item{scores}{A matrix of estimated FPC scores for level1 and level2.} 
\item{efunctions}{A matrix of estimated eigenfunctions of the functional
covariance, i.e., the FPC basis functions for levels 1 and 2.} 
\item{evalues}{Estimated eigenvalues of the covariance operator, i.e., variances 
of FPC scores for levels 1 and 2.}
\item{npc}{Number of FPCs: either the supplied \code{npc}, or the minimum
number of basis functions needed to explain proportion \code{pve} of the
variance in the observed curves for levels 1 and 2.} 
\item{sigma2}{Estimated measurement error variance.}
}
\description{
Decompose dense or sparse multilevel functional observations using multilevel 
functional principal component analysis with the fast covariance estimation 
approach.
}
\details{
The fast MFPCA approach (Cui et al., 2023) uses FACE (Xiao et al., 2016) to estimate 
covariance functions and mixed model equations (MME) to predict 
scores for each level. As a result, it has lower computational complexity than 
MFPCA (Di et al., 2009) implemented in the \code{mfpca.sc} function, and
can be applied to decompose data sets with over 10000 subjects and over 10000 
dimensions.
}
\examples{
data(DTI)
mfpca.DTI <- mfpca.face(Y = DTI$cca, id = DTI$ID, twoway = TRUE)
}
\references{
Cui, E., Li, R., Crainiceanu, C., and Xiao, L. (2023). Fast multilevel
functional principal component analysis. \emph{Journal of Computational and 
Graphical Statistics}, 32(3), 366-377.

Di, C., Crainiceanu, C., Caffo, B., and Punjabi, N. (2009).
Multilevel functional principal component analysis. \emph{Annals of Applied
Statistics}, 3, 458-488.

Xiao, L., Ruppert, D., Zipunnikov, V., and Crainiceanu, C. (2016).
Fast covariance estimation for high-dimensional functional data.  
\emph{Statistics and Computing}, 26, 409-421.
}
\author{
Ruonan Li \email{rli20@ncsu.edu}, Erjia Cui \email{ecui1@jhmi.edu}
}
