% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRTlong.R
\name{CRTlong}
\alias{CRTlong}
\title{Automatic coding for Cognitive Reflection Test LONG (Primi et al., 2016) open-ended responses}
\usage{
CRTlong(
  item1 = NULL,
  item2 = NULL,
  item3 = NULL,
  item4 = NULL,
  item5 = NULL,
  item6 = NULL,
  codingscheme = "categ"
)
}
\arguments{
\item{item1}{Vector of responses to the first CRT question, or NULL if not provided.}

\item{item2}{Vector of responses to the second CRT question, or NULL if not provided.}

\item{item3}{Vector of responses to the third CRT question, or NULL if not provided.}

\item{item4}{Vector of responses to the fourth CRT question, or NULL if not provided.}

\item{item5}{Vector of responses to the fifth CRT question, or NULL if not provided.}

\item{item6}{Vector of responses to the sixth CRT question, or NULL if not provided.}

\item{codingscheme}{A character string indicating the desired coding scheme. Options are "categ" for the original 1, 2, 3 coding, "sum" for a sum of binary-coded correct answers, or "mean" for an average of binary-coded correct answers. The default is "categ".}
}
\value{
A list containing the coded and, if applicable, binary-coded responses for each provided CRT question. For "sum" or "mean" coding schemes, additional vectors representing these aggregate scores are included.
}
\description{
Applies coding logic to any number of provided CRT question responses and supports multiple coding schemes. This function can output original coded responses, binary-coded responses, and aggregate scores based on these binary codings.
}
\note{
Developed by Giuseppe Corbelli, email: giuseppe.corbelli@uninettunouniversity.net
}
\examples{
# Automated scoring for CRTlong responses using the categorical coding scheme:
reflectR::CRTlong(
item1 = c("five", "5 cents", "10"),
item2 = c("5", "one hundred", "100"),
item3 = c("47", "24", "forty seven"),
item4 = c("3 elves", "dunno", "six"),
item5 = c("29", "thirty", "30"),
item6 = c("15", "fifteen", "0"),
codingscheme = "categ")

# Compute the sum score for CRTlong responses based on binary-coded correctness:
reflectR::CRTlong(
item1 = c("five", "5 cents", "10"),
item2 = c("5", "one hundred", "100"),
item3 = c("47", "24", "forty seven"),
item4 = c("3 elves", "dunno", "six"),
item5 = c("29", "thirty", "30"),
item6 = c("15", "fifteen", "0"),
codingscheme = "sum")$crt_sum
}
