% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_raw_tabs.R
\name{format_raw_tabs}
\alias{format_raw_tabs}
\title{Format raw survival and NAR tables so they are ready for reconstruction algorithm}
\usage{
format_raw_tabs(raw_NAR, raw_surv, tau = NULL)
}
\arguments{
\item{raw_NAR}{A data frame with the columns 'time' and NAR' at least.}

\item{raw_surv}{A data frame with the columns 'time' and 'survival' at least.}

\item{tau}{End of follow-up time, defaults to last time in NAR table.}
}
\value{
A list with aug_NAR and aug_surv, properly cleaned tables that can be used as input in KM_reconstruct().
}
\description{
Augment a raw number at risk table with the necessary information to run
the reconstruction algorithm.
}
\examples{
data(pembro_clicks)
data(pembro_NAR)
augTabs <- format_raw_tabs(raw_NAR=pembro_NAR, raw_surv=pembro_clicks)

}
