% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_at.R
\name{step_mutate_at}
\alias{step_mutate_at}
\title{Mutate multiple columns using dplyr}
\usage{
step_mutate_at(
  recipe,
  ...,
  fn,
  role = "predictor",
  trained = FALSE,
  inputs = NULL,
  skip = FALSE,
  id = rand_id("mutate_at")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{fn}{A function fun, a quosure style lambda `~ fun(.)`` or a list of
either form. (see \code{\link[dplyr:mutate_all]{dplyr::mutate_at()}}). \strong{Note that this argument must be
named}.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{inputs}{A vector of column names populated by \code{\link[=prep]{prep()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_mutate_at()} creates a \emph{specification} of a recipe step that will
modify the selected variables using a common function via
\code{\link[dplyr:mutate_all]{dplyr::mutate_at()}}.
}
\details{
When using this flexible step, use extra care to avoid data leakage in your
preprocessing. Consider, for example, the transformation \code{x = w > mean(w)}.
When applied to new data or testing data, this transformation would use the
mean of \code{w} from the \emph{new} data, not the mean of \code{w} from the training data.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms} and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
library(dplyr)
recipe(~., data = iris) \%>\%
  step_mutate_at(contains("Length"), fn = ~ 1 / .) \%>\%
  prep() \%>\%
  bake(new_data = NULL) \%>\%
  slice(1:10)

recipe(~., data = iris) \%>\%
  # leads to more columns being created.
  step_mutate_at(contains("Length"), fn = list(log = log, sqrt = sqrt)) \%>\%
  prep() \%>\%
  bake(new_data = NULL) \%>\%
  slice(1:10)
}
\seealso{
Other multivariate transformation steps: 
\code{\link{step_classdist}()},
\code{\link{step_classdist_shrunken}()},
\code{\link{step_depth}()},
\code{\link{step_geodist}()},
\code{\link{step_ica}()},
\code{\link{step_isomap}()},
\code{\link{step_kpca}()},
\code{\link{step_kpca_poly}()},
\code{\link{step_kpca_rbf}()},
\code{\link{step_nnmf}()},
\code{\link{step_nnmf_sparse}()},
\code{\link{step_pca}()},
\code{\link{step_pls}()},
\code{\link{step_ratio}()},
\code{\link{step_spatialsign}()}

Other dplyr steps: 
\code{\link{step_arrange}()},
\code{\link{step_filter}()},
\code{\link{step_mutate}()},
\code{\link{step_rename}()},
\code{\link{step_rename_at}()},
\code{\link{step_sample}()},
\code{\link{step_select}()},
\code{\link{step_slice}()}
}
\concept{dplyr steps}
\concept{multivariate transformation steps}
