% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/YeoJohnson.R, R/misc.R, R/printing.R
\name{yj_transform}
\alias{yj_transform}
\alias{estimate_yj}
\alias{ellipse_check}
\alias{printer}
\alias{prepare}
\alias{is_trained}
\alias{sel2char}
\alias{print_step}
\title{Internal Functions}
\usage{
yj_transform(x, lambda, ind_neg = NULL, eps = 0.001)

estimate_yj(
  dat,
  limits = c(-5, 5),
  num_unique = 5,
  na_rm = TRUE,
  call = caller_env(2)
)

ellipse_check(...)

printer(
  tr_obj = NULL,
  untr_obj = NULL,
  trained = FALSE,
  width = max(20, options()$width - 30)
)

prepare(x, ...)

is_trained(x)

sel2char(x)

print_step(
  tr_obj = NULL,
  untr_obj = NULL,
  trained = FALSE,
  title = NULL,
  width = max(20, options()$width - 30),
  case_weights = NULL
)
}
\arguments{
\item{x}{A list of selectors}

\item{...}{Arguments pass in from a call to \code{step}.}

\item{tr_obj}{A character vector of names that have been
resolved during preparing the recipe (e.g. the \code{columns} object
of \code{\link[=step_log]{step_log()}}).}

\item{untr_obj}{An object of selectors prior to prepping the
recipe (e.g. \code{terms} in most steps).}

\item{trained}{A logical for whether the step has been trained.}

\item{width}{An integer denoting where the output should be wrapped.}

\item{title}{A character, shortly describing the action the step takes.}
}
\value{
\code{ellipse_check()}: If not empty, a list of quosures. If empty, an
error is thrown.

\code{printer()}: \code{NULL}, invisibly.

\code{is_trained()}: A single logical.

\code{sel2char()}: A character vector.

\code{print_step()}: \code{NULL}, invisibly.
}
\description{
\code{ellipse_check()} is deprecated. Instead, empty selections should be
supported by all steps.

\code{printer()} is used for printing steps.

\code{is_trained()} is a helper function that returned a single logical to
indicate whether a recipe is traine or not.

\code{sel2char()} takes a list of selectors (e.g. \code{terms} in most steps) and
returns a character vector version for printing.

\code{print_step()} is used for printing steps.
}
\seealso{
\link{developer_functions}

\link{developer_functions}

\link{developer_functions}
}
\keyword{internal}
