library(rearrr)
context("create_rotation_matrix2/3()")


test_that("create_rotation_matrix_2d_()", {

  # Generate expectations for 'create_rotation_matrix_2d_'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = create_rotation_matrix_2d_,
  #   args_values = list(
  #     "deg" = list(0,-360, 360, 90, -270, 180, -180, -90, 270, 10, -10, NA)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'create_rotation_matrix_2d_'                                       ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing create_rotation_matrix_2d_(deg = 0)
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- create_rotation_matrix_2d_(deg = 0)
  # Testing class
  expect_equal(
    class(output_19148)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing column values
  expect_equal(
    output_19148[, 1],
    c(1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19148[, 2],
    c(0, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_19148),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_19148),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    isSymmetric(output_19148))

  # Testing create_rotation_matrix_2d_(deg = -360)
  # Changed from baseline: deg = -360
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- create_rotation_matrix_2d_(deg = -360)
  # Testing class
  expect_equal(
    class(output_19370)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19370,
    type = "double")
  # Testing column values
  expect_equal(
    output_19370[, 1],
    c(1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19370[, 2],
    c(0, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_19370),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_19370),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    isSymmetric(output_19370))

  # Testing create_rotation_matrix_2d_(deg = -10)
  # Changed from baseline: deg = -10
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- create_rotation_matrix_2d_(deg = -10)
  # Testing class
  expect_equal(
    class(output_12861)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12861,
    type = "double")
  # Testing column values
  expect_equal(
    output_12861[, 1],
    c(0.98481, -0.17365),
    tolerance = 1e-4)
  expect_equal(
    output_12861[, 2],
    c(0.17365, 0.98481),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_12861),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_12861),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12861),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_12861))

  # Testing create_rotation_matrix_2d_(deg = NA)
  # Changed from baseline: deg = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(create_rotation_matrix_2d_(deg = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'deg': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_rotation_matrix_2d_(deg = 360)
  # Changed from baseline: deg = 360
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- create_rotation_matrix_2d_(deg = 360)
  # Testing class
  expect_equal(
    class(output_16417)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16417,
    type = "double")
  # Testing column values
  expect_equal(
    output_16417[, 1],
    c(1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_16417[, 2],
    c(0, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_16417),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_16417),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16417),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    isSymmetric(output_16417))

  # Testing create_rotation_matrix_2d_(deg = 90)
  # Changed from baseline: deg = 90
  xpectr::set_test_seed(42)
  # Assigning output
  output_15190 <- create_rotation_matrix_2d_(deg = 90)
  # Testing class
  expect_equal(
    class(output_15190)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_15190,
    type = "double")
  # Testing column values
  expect_equal(
    output_15190[, 1],
    c(0, 1),
    tolerance = 1e-4)
  expect_equal(
    output_15190[, 2],
    c(-1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_15190),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_15190),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15190),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_15190))

  # Testing create_rotation_matrix_2d_(deg = -270)
  # Changed from baseline: deg = -270
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- create_rotation_matrix_2d_(deg = -270)
  # Testing class
  expect_equal(
    class(output_17365)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17365,
    type = "double")
  # Testing column values
  expect_equal(
    output_17365[, 1],
    c(0, 1),
    tolerance = 1e-4)
  expect_equal(
    output_17365[, 2],
    c(-1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_17365),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_17365),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_17365))

  # Testing create_rotation_matrix_2d_(deg = 180)
  # Changed from baseline: deg = 180
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- create_rotation_matrix_2d_(deg = 180)
  # Testing class
  expect_equal(
    class(output_11346)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11346,
    type = "double")
  # Testing column values
  expect_equal(
    output_11346[, 1],
    c(-1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_11346[, 2],
    c(0, -1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_11346),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_11346),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    isSymmetric(output_11346))

  # Testing create_rotation_matrix_2d_(deg = -180)
  # Changed from baseline: deg = -180
  xpectr::set_test_seed(42)
  # Assigning output
  output_16569 <- create_rotation_matrix_2d_(deg = -180)
  # Testing class
  expect_equal(
    class(output_16569)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16569,
    type = "double")
  # Testing column values
  expect_equal(
    output_16569[, 1],
    c(-1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_16569[, 2],
    c(0, -1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_16569),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_16569),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16569),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    isSymmetric(output_16569))

  # Testing create_rotation_matrix_2d_(deg = -90)
  # Changed from baseline: deg = -90
  xpectr::set_test_seed(42)
  # Assigning output
  output_17050 <- create_rotation_matrix_2d_(deg = -90)
  # Testing class
  expect_equal(
    class(output_17050)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17050,
    type = "double")
  # Testing column values
  expect_equal(
    output_17050[, 1],
    c(0, -1),
    tolerance = 1e-4)
  expect_equal(
    output_17050[, 2],
    c(1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_17050),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_17050),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17050),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_17050))

  # Testing create_rotation_matrix_2d_(deg = 270)
  # Changed from baseline: deg = 270
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- create_rotation_matrix_2d_(deg = 270)
  # Testing class
  expect_equal(
    class(output_14577)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14577,
    type = "double")
  # Testing column values
  expect_equal(
    output_14577[, 1],
    c(0, -1),
    tolerance = 1e-4)
  expect_equal(
    output_14577[, 2],
    c(1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_14577),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_14577),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_14577))

  # Testing create_rotation_matrix_2d_(deg = 10)
  # Changed from baseline: deg = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- create_rotation_matrix_2d_(deg = 10)
  # Testing class
  expect_equal(
    class(output_17191)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17191,
    type = "double")
  # Testing column values
  expect_equal(
    output_17191[, 1],
    c(0.98481, 0.17365),
    tolerance = 1e-4)
  expect_equal(
    output_17191[, 2],
    c(-0.17365, 0.98481),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_17191),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_17191),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(2L, 2L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_17191))

  # Testing create_rotation_matrix_2d_(deg = NULL)
  # Changed from baseline: deg = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(create_rotation_matrix_2d_(deg = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'deg': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'create_rotation_matrix_2d_'                              ####
  #


})

test_that("create_rotation_matrix_3d_()", {

  # Generate expectations for 'create_rotation_matrix_3d_'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = create_rotation_matrix_3d_,
  #   args_values = list(
  #     "x_deg" = list(0, -360, 90, -270, 45, NA),
  #     "y_deg" = list(0, -360, 90, -270, 45, NA),
  #     "z_deg" = list(0, -360, 90, -270, 45, NA)
  #   ), extra_combinations = list(
  #     list("x_deg" = 0, "y_deg" = 90, "z_deg" = 180)
  #   ),
  #   indentation = 2
  # )


  ## Testing 'create_rotation_matrix_3d_'                                       ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- create_rotation_matrix_3d_(x_deg = 0, y_deg = 0, z_deg = 0)
  # Testing class
  expect_equal(
    class(output_19148)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing column values
  expect_equal(
    output_19148[, 1],
    c(1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19148[, 2],
    c(0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19148[, 3],
    c(0, 0, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_19148),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_19148),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    isSymmetric(output_19148))

  # Testing create_rotation_matrix_3d_(x_deg = -360, y_deg...
  # Changed from baseline: x_deg = -360
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- create_rotation_matrix_3d_(x_deg = -360, y_deg = 0, z_deg = 0)
  # Testing class
  expect_equal(
    class(output_19370)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19370,
    type = "double")
  # Testing column values
  expect_equal(
    output_19370[, 1],
    c(1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19370[, 2],
    c(0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19370[, 3],
    c(0, 0, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_19370),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_19370),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    isSymmetric(output_19370))

  # Testing create_rotation_matrix_3d_(x_deg = 90, y_deg =...
  # Changed from baseline: x_deg = 90
  xpectr::set_test_seed(42)
  # Assigning output
  output_12861 <- create_rotation_matrix_3d_(x_deg = 90, y_deg = 0, z_deg = 0)
  # Testing class
  expect_equal(
    class(output_12861)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_12861,
    type = "double")
  # Testing column values
  expect_equal(
    output_12861[, 1],
    c(1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_12861[, 2],
    c(0, 0, 1),
    tolerance = 1e-4)
  expect_equal(
    output_12861[, 3],
    c(0, -1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_12861),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_12861),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12861),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_12861))

  # Testing create_rotation_matrix_3d_(x_deg = -270, y_deg...
  # Changed from baseline: x_deg = -270
  xpectr::set_test_seed(42)
  # Assigning output
  output_18304 <- create_rotation_matrix_3d_(x_deg = -270, y_deg = 0, z_deg = 0)
  # Testing class
  expect_equal(
    class(output_18304)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_18304,
    type = "double")
  # Testing column values
  expect_equal(
    output_18304[, 1],
    c(1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_18304[, 2],
    c(0, 0, 1),
    tolerance = 1e-4)
  expect_equal(
    output_18304[, 3],
    c(0, -1, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_18304),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_18304),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18304),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_18304))

  # Testing create_rotation_matrix_3d_(x_deg = 45, y_deg =...
  # Changed from baseline: x_deg = 45
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- create_rotation_matrix_3d_(x_deg = 45, y_deg = 0, z_deg = 0)
  # Testing class
  expect_equal(
    class(output_16417)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_16417,
    type = "double")
  # Testing column values
  expect_equal(
    output_16417[, 1],
    c(1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_16417[, 2],
    c(0, 0.70711, 0.70711),
    tolerance = 1e-4)
  expect_equal(
    output_16417[, 3],
    c(0, -0.70711, 0.70711),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_16417),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_16417),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16417),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_16417))

  # Testing create_rotation_matrix_3d_(x_deg = NA, y_deg =...
  # Changed from baseline: x_deg = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(create_rotation_matrix_3d_(x_deg = NA, y_deg = 0, z_deg = 0), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_deg': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_rotation_matrix_3d_(x_deg = NULL, y_deg...
  # Changed from baseline: x_deg = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(create_rotation_matrix_3d_(x_deg = NULL, y_deg = 0, z_deg = 0), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_deg': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: x_deg, y_deg, z_deg
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- create_rotation_matrix_3d_(x_deg = 0, y_deg = 90, z_deg = 180)
  # Testing class
  expect_equal(
    class(output_11346)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11346,
    type = "double")
  # Testing column values
  expect_equal(
    output_11346[, 1],
    c(0, 0, -1),
    tolerance = 1e-4)
  expect_equal(
    output_11346[, 2],
    c(0, -1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_11346[, 3],
    c(-1, 0, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_11346),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_11346),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    isSymmetric(output_11346))

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: y_deg = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(create_rotation_matrix_3d_(x_deg = 0, y_deg = NA, z_deg = 0), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_deg': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: y_deg = -360
  xpectr::set_test_seed(42)
  # Assigning output
  output_17050 <- create_rotation_matrix_3d_(x_deg = 0, y_deg = -360, z_deg = 0)
  # Testing class
  expect_equal(
    class(output_17050)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17050,
    type = "double")
  # Testing column values
  expect_equal(
    output_17050[, 1],
    c(1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_17050[, 2],
    c(0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_17050[, 3],
    c(0, 0, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_17050),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_17050),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17050),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    isSymmetric(output_17050))

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: y_deg = 90
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- create_rotation_matrix_3d_(x_deg = 0, y_deg = 90, z_deg = 0)
  # Testing class
  expect_equal(
    class(output_14577)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14577,
    type = "double")
  # Testing column values
  expect_equal(
    output_14577[, 1],
    c(0, 0, -1),
    tolerance = 1e-4)
  expect_equal(
    output_14577[, 2],
    c(0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_14577[, 3],
    c(1, 0, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_14577),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_14577),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_14577))

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: y_deg = -270
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- create_rotation_matrix_3d_(x_deg = 0, y_deg = -270, z_deg = 0)
  # Testing class
  expect_equal(
    class(output_17191)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_17191,
    type = "double")
  # Testing column values
  expect_equal(
    output_17191[, 1],
    c(0, 0, -1),
    tolerance = 1e-4)
  expect_equal(
    output_17191[, 2],
    c(0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_17191[, 3],
    c(1, 0, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_17191),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_17191),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_17191))

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: y_deg = 45
  xpectr::set_test_seed(42)
  # Assigning output
  output_19346 <- create_rotation_matrix_3d_(x_deg = 0, y_deg = 45, z_deg = 0)
  # Testing class
  expect_equal(
    class(output_19346)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19346,
    type = "double")
  # Testing column values
  expect_equal(
    output_19346[, 1],
    c(0.70711, 0, -0.70711),
    tolerance = 1e-4)
  expect_equal(
    output_19346[, 2],
    c(0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19346[, 3],
    c(0.70711, 0, 0.70711),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_19346),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_19346),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19346),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_19346))

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: y_deg = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(create_rotation_matrix_3d_(x_deg = 0, y_deg = NULL, z_deg = 0), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_deg': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: z_deg = -360
  xpectr::set_test_seed(42)
  # Assigning output
  output_14622 <- create_rotation_matrix_3d_(x_deg = 0, y_deg = 0, z_deg = -360)
  # Testing class
  expect_equal(
    class(output_14622)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14622,
    type = "double")
  # Testing column values
  expect_equal(
    output_14622[, 1],
    c(1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_14622[, 2],
    c(0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_14622[, 3],
    c(0, 0, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_14622),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_14622),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14622),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    isSymmetric(output_14622))

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: z_deg = 90
  xpectr::set_test_seed(42)
  # Assigning output
  output_19400 <- create_rotation_matrix_3d_(x_deg = 0, y_deg = 0, z_deg = 90)
  # Testing class
  expect_equal(
    class(output_19400)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19400,
    type = "double")
  # Testing column values
  expect_equal(
    output_19400[, 1],
    c(0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19400[, 2],
    c(-1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19400[, 3],
    c(0, 0, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_19400),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_19400),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19400),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_19400))

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: z_deg = -270
  xpectr::set_test_seed(42)
  # Assigning output
  output_19782 <- create_rotation_matrix_3d_(x_deg = 0, y_deg = 0, z_deg = -270)
  # Testing class
  expect_equal(
    class(output_19782)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19782,
    type = "double")
  # Testing column values
  expect_equal(
    output_19782[, 1],
    c(0, 1, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19782[, 2],
    c(-1, 0, 0),
    tolerance = 1e-4)
  expect_equal(
    output_19782[, 3],
    c(0, 0, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_19782),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_19782),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19782),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_19782))

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: z_deg = 45
  xpectr::set_test_seed(42)
  # Assigning output
  output_11174 <- create_rotation_matrix_3d_(x_deg = 0, y_deg = 0, z_deg = 45)
  # Testing class
  expect_equal(
    class(output_11174)[[1]],
    "matrix",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_11174,
    type = "double")
  # Testing column values
  expect_equal(
    output_11174[, 1],
    c(0.70711, 0.70711, 0),
    tolerance = 1e-4)
  expect_equal(
    output_11174[, 2],
    c(-0.70711, 0.70711, 0),
    tolerance = 1e-4)
  expect_equal(
    output_11174[, 3],
    c(0, 0, 1),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    colnames(output_11174),
    NULL,
    fixed = TRUE)
  # Testing row names
  expect_equal(
    rownames(output_11174),
    NULL,
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(3L, 3L))
  # Testing symmetry
  expect_true(
    !isSymmetric(output_11174))

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: z_deg = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(create_rotation_matrix_3d_(x_deg = 0, y_deg = 0, z_deg = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_deg': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_rotation_matrix_3d_(x_deg = 0, y_deg = ...
  # Changed from baseline: z_deg = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(create_rotation_matrix_3d_(x_deg = 0, y_deg = 0, z_deg = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'z_deg': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'create_rotation_matrix_3d_'                              ####
  #

})
