library(rearrr)
context("transfer_centroids()")

test_that("transfer_centroids()", {
  # Set seed
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "x" = runif(20),
    "y" = runif(20),
    "g" = c(1, 1, 1, 1, 1,
            2, 2, 2, 2, 2,
            3, 3, 3, 3, 3,
            4, 4, 4, 4, 4),
    stringsAsFactors = FALSE
  )

  # Create another data frame with different x and y values
  df2 <- df
  df2$x <- runif(20)
  df2$y <- runif(20)

  # Check centroids before transfer
  df_centroids <- df %>%
    dplyr::group_by(g) %>%
    dplyr::summarize_all(mean)

  df2_centroids <- df2 %>%
    dplyr::group_by(g) %>%
    dplyr::summarize_all(mean)

  ## Testing 'df_centroids'                                                 ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(df_centroids),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    df_centroids[["g"]],
    c(1, 2, 3, 4),
    tolerance = 1e-4)
  expect_equal(
    df_centroids[["x"]],
    c(0.72204, 0.55048, 0.56585, 0.61421),
    tolerance = 1e-4)
  expect_equal(
    df_centroids[["y"]],
    c(0.61215, 0.61863, 0.52518, 0.51326),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(df_centroids),
    c("g", "x", "y"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(df_centroids),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(df_centroids),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(df_centroids),
    4:3)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(df_centroids)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df_centroids'                                        ####

  ## Testing 'df2_centroids'                                                ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(df2_centroids),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    df2_centroids[["g"]],
    c(1, 2, 3, 4),
    tolerance = 1e-4)
  expect_equal(
    df2_centroids[["x"]],
    c(0.45161, 0.81502, 0.38046, 0.47457),
    tolerance = 1e-4)
  expect_equal(
    df2_centroids[["y"]],
    c(0.76683, 0.44453, 0.21533, 0.32374),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(df2_centroids),
    c("g", "x", "y"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(df2_centroids),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(df2_centroids),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(df2_centroids),
    4:3)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(df2_centroids)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df2_centroids'                                       ####

  df3 <- transfer_centroids(
    to_data = df2,
    from_data = df,
    cols = c("x", "y"),
    group_cols = "g"
  )

  df3_restored_centroids <- df3 %>%
    dplyr::group_by(g) %>%
    dplyr::summarize_all(mean)

  expect_equal(df3_restored_centroids, df_centroids)


  ## Testing 'df3'                                                          ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(df3),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    df3[["x"]],
    c(0.64999, 0.7062, 0.30786, 1.24397, 0.70218, 0.69304, 0.62321,
      0.37544, 0.70643, 0.3543, 0.51882, 0.53214, 0.58388, 0.97008,
      0.22433, 0.88844, 0.81692, 0.31091, 0.40073, 0.65406),
    tolerance = 1e-4)
  expect_equal(
    df3[["y"]],
    c(0.52093, 0.82814, 0.60486, 0.41181, 0.69501, 0.36357, 0.44538,
      1.00225, 0.8673, 0.41464, 0.35283, 0.45032, 0.52623, 0.78924,
      0.50725, 0.90887, 0.1974, 0.56501, 0.70392, 0.19109),
    tolerance = 1e-4)
  expect_equal(
    df3[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(df3),
    c("x", "y", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(df3),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(df3),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(df3),
    c(20L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(df3)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df3'                                                 ####


})

test_that("fuzz testing transfer_centroids()", {
  # Set seed
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "x" = runif(20),
    "y" = runif(20),
    "g" = c(1, 1, 1, 1, 1,
            2, 2, 2, 2, 2,
            3, 3, 3, 3, 3,
            4, 4, 4, 4, 4),
    stringsAsFactors = FALSE
  )

  # Create another data frame with different x and y values
  df2 <- df
  df2$x <- runif(20)
  df2$y <- runif(20)

  df3 <- df
  df3$x <- runif(20)*100
  df3$y <- runif(20)*100

  # Generate expectations for 'transfer_centroids'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = transfer_centroids,
  #   args_values = list(
  #     "to_data" = list(df2, matrix(1:20, nrow = 10, ncol = 2), c(1, 2, 3, 4), NA),
  #     "from_data" = list(df, df2, df3, data.frame("x" = c(1, 2, 3, 4)), NA),
  #     "cols" = list(c("x", "y"), c("x", "z"), "g", 1, NA),
  #     "group_cols" = list(NULL, "g", "j", c("x", "y"), NA)
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'transfer_centroids'                                             ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing transfer_centroids(to_data = df2, from_data ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- transfer_centroids(to_data = df2, from_data = df, cols = c("x", "y"), group_cols = NULL)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(0.46229, 0.5185, 0.12016, 1.05627, 0.51448, 1.04031, 0.97049,
      0.72271, 1.0537, 0.70157, 0.41616, 0.42948, 0.48122, 0.86742,
      0.12167, 0.83153, 0.76001, 0.254, 0.34382, 0.59714),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.8053, 1.11251, 0.88924, 0.69618, 0.97938, 0.31917, 0.40098,
      0.95785, 0.8229, 0.37024, 0.17268, 0.27017, 0.34608, 0.60909,
      0.3271, 0.84905, 0.13758, 0.50518, 0.6441, 0.13126),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(20L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = matrix(1:20, nr...
  # Changed from baseline: to_data = matrix(1:20...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19370 <- xpectr::capture_side_effects(transfer_centroids(to_data = matrix(1:20, nrow = 10, ncol = 2), from_data = df, cols = c("x", "y"), group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'to_data': Must be of type 'data.frame', not 'matrix'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19370[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = c(1, 2, 3, 4), ...
  # Changed from baseline: to_data = c(1, 2, 3, 4)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(transfer_centroids(to_data = c(1, 2, 3, 4), from_data = df, cols = c("x", "y"), group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'to_data': Must be of type 'data.frame', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = NA, from_data =...
  # Changed from baseline: to_data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(transfer_centroids(to_data = NA, from_data = df, cols = c("x", "y"), group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'to_data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = NULL, from_data...
  # Changed from baseline: to_data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(transfer_centroids(to_data = NULL, from_data = df, cols = c("x", "y"), group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'to_data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: from_data = df2
  xpectr::set_test_seed(42)
  # Assigning output
  output_15190 <- transfer_centroids(to_data = df2, from_data = df2, cols = c("x", "y"), group_cols = NULL)
  # Testing class
  expect_equal(
    class(output_15190),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15190[["x"]],
    c(0.37956, 0.43577, 0.03743, 0.97354, 0.43175, 0.95758, 0.88775,
      0.63998, 0.97097, 0.61884, 0.33343, 0.34675, 0.39849, 0.78469,
      0.03894, 0.7488, 0.67728, 0.17126, 0.26109, 0.51441),
    tolerance = 1e-4)
  expect_equal(
    output_15190[["y"]],
    c(0.67561, 0.98282, 0.75954, 0.56649, 0.84969, 0.18947, 0.27129,
      0.82816, 0.6932, 0.24054, 0.04299, 0.14048, 0.21639, 0.4794,
      0.19741, 0.71936, 0.00788, 0.37549, 0.51441, 0.00157),
    tolerance = 1e-4)
  expect_equal(
    output_15190[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_15190),
    c("x", "y", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15190),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15190),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15190),
    c(20L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15190)),
    character(0),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: from_data = df3
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- transfer_centroids(to_data = df2, from_data = df3, cols = c("x", "y"), group_cols = NULL)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["x"]],
    c(47.2413, 47.29752, 46.89917, 47.83528, 47.29349, 47.81932, 47.7495,
      47.50172, 47.83271, 47.48058, 47.19517, 47.20849, 47.26023,
      47.64644, 46.90068, 47.61054, 47.53902, 47.03301, 47.12283,
      47.37616),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["y"]],
    c(54.66998, 54.97719, 54.75392, 54.56086, 54.84406, 54.18385, 54.26566,
      54.82253, 54.68758, 54.23492, 54.03736, 54.13485, 54.21076,
      54.47377, 54.19178, 54.71373, 54.00226, 54.36986, 54.50878,
      53.99594),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("x", "y", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(20L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: from_data = data.fram...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(transfer_centroids(to_data = df2, from_data = data.frame(x = c(1, 2, 3, 4)), cols = c("x", "y"), group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * 'to_data' and 'from_data' must have the exact same columns."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: from_data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(transfer_centroids(to_data = df2, from_data = NA, cols = c("x", "y"), group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'from_data': Must be of type 'data.frame', not 'logical'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: from_data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(transfer_centroids(to_data = df2, from_data = NULL, cols = c("x", "y"), group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'from_data': Must be of type 'data.frame', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: cols = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(transfer_centroids(to_data = df2, from_data = df, cols = 1, group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cols': Must be of type 'character', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(transfer_centroids(to_data = df2, from_data = df, cols = NA, group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cols': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: cols = c("x", "z")
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(transfer_centroids(to_data = df2, from_data = df, cols = c("x", "z"), group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * some names in 'cols' were not columns in 'to_data'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: cols = "g"
  xpectr::set_test_seed(42)
  # Assigning output
  output_12554 <- transfer_centroids(to_data = df2, from_data = df, cols = "g", group_cols = NULL)
  # Testing class
  expect_equal(
    class(output_12554),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12554[["x"]],
    c(0.37956, 0.43577, 0.03743, 0.97354, 0.43175, 0.95758, 0.88775,
      0.63998, 0.97097, 0.61884, 0.33343, 0.34675, 0.39849, 0.78469,
      0.03894, 0.7488, 0.67728, 0.17126, 0.26109, 0.51441),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["y"]],
    c(0.67561, 0.98282, 0.75954, 0.56649, 0.84969, 0.18947, 0.27129,
      0.82816, 0.6932, 0.24054, 0.04299, 0.14048, 0.21639, 0.4794,
      0.19741, 0.71936, 0.00788, 0.37549, 0.51441, 0.00157),
    tolerance = 1e-4)
  expect_equal(
    output_12554[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_12554),
    c("x", "y", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12554),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12554),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12554),
    c(20L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12554)),
    character(0),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: cols = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(transfer_centroids(to_data = df2, from_data = df, cols = NULL, group_cols = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cols': Must be of type 'character', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: group_cols = "g"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19400 <- transfer_centroids(to_data = df2, from_data = df, cols = c("x", "y"), group_cols = "g")
  # Testing class
  expect_equal(
    class(output_19400),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19400[["x"]],
    c(0.64999, 0.7062, 0.30786, 1.24397, 0.70218, 0.69304, 0.62321,
      0.37544, 0.70643, 0.3543, 0.51882, 0.53214, 0.58388, 0.97008,
      0.22433, 0.88844, 0.81692, 0.31091, 0.40073, 0.65406),
    tolerance = 1e-4)
  expect_equal(
    output_19400[["y"]],
    c(0.52093, 0.82814, 0.60486, 0.41181, 0.69501, 0.36357, 0.44538,
      1.00225, 0.8673, 0.41464, 0.35283, 0.45032, 0.52623, 0.78924,
      0.50725, 0.90887, 0.1974, 0.56501, 0.70392, 0.19109),
    tolerance = 1e-4)
  expect_equal(
    output_19400[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19400),
    c("x", "y", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19400),
    c("numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19400),
    c("double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19400),
    c(20L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19400)),
    character(0),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: group_cols = "j"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(transfer_centroids(to_data = df2, from_data = df, cols = c("x", "y"), group_cols = "j"), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * some names in 'group_cols' were not columns in 'to_data'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: group_cols = c("x", "y")
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(transfer_centroids(to_data = df2, from_data = df, cols = c("x", "y"), group_cols = c("x", "y")), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * some names in 'cols' were also in 'group_cols'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing transfer_centroids(to_data = df2, from_data ...
  # Changed from baseline: group_cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(transfer_centroids(to_data = df2, from_data = df, cols = c("x", "y"), group_cols = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'group_cols': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'transfer_centroids'                                    ####
  #

})
