% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdrandinf.R
\name{rdrandinf}
\alias{rdrandinf}
\title{Randomization Inference for RD Designs under Local Randomization}
\usage{
rdrandinf(Y, R, cutoff = 0, wl = NULL, wr = NULL, reps = 1000,
  statistic = "diffmeans", p = 0, nulltau = 0, evall = NULL,
  evalr = NULL, kernel = "uniform", ci, interfci = NULL,
  seed = NULL, fuzzy = NULL, d = NULL, dscale = NULL,
  bernoulli = NULL, quietly = FALSE, covariates, obsmin = NULL,
  wmin = NULL, wobs = NULL, wstep = NULL, nwindows = 10,
  rdwstat = "diffmeans", approx = FALSE, rdwreps = 1000,
  level = 0.15, plot = FALSE, obsstep = NULL)
}
\arguments{
\item{Y}{a vector containing the values of the outcome variable.}

\item{R}{a vector containing the values of the running variable.}

\item{cutoff}{the RD cutoff (default is 0).}

\item{wl}{the left limit of the window. The default takes the minimum of the running variable.}

\item{wr}{the right limit of the window. The default takes the maximum of the running variable.}

\item{reps}{the number of replications (default is 1000).}

\item{statistic}{the statistic to be used in the balance tests. Allowed options are \code{diffmeans} (difference in means statistic), \code{ksmirnov} (Kolmogorov-Smirnov statistic) and \code{ranksum} (Wilcoxon-Mann-Whitney standardized statistic). Default option is \code{diffmeans}. The statistic \code{ttest} is equivalent to \code{diffmeans} and included for backward compatibility.}

\item{p}{the order of the polynomial for outcome transformation model (default is 0).}

\item{nulltau}{the value of the treatment effect under the null hypothesis (default is 0).}

\item{evall}{the point at the left of the cutoff at which to evaluate the transformed outcome is evaluated. Default is the cutoff value.}

\item{evalr}{specifies the point at the right of the cutoff at which the transformed outcome is evaluated. Default is the cutoff value.}

\item{kernel}{specifies the type of kernel to use as weighting scheme. Allowed kernel types are \code{uniform} (uniform kernel), \code{triangular} (triangular kernel) and \code{epan} (Epanechnikov kernel). Default is \code{uniform}.}

\item{ci}{calculates a confidence interval for the treatment effect by test inversion. \code{ci} can be specified as a scalar or a vector, where the first element indicates the level of the confidence interval and the remaining elements, if specified, indicate the grid of treatment effects to be evaluated. This option uses \code{rdsensitivity} to calculate the confidence interval. See corresponding help for details.}

\item{interfci}{the level for Rosenbaum's confidence interval under arbitrary interference between units.}

\item{seed}{the seed to be used for the randomization test.}

\item{fuzzy}{indicates that the RD design is fuzzy. \code{fuzzy} can be specified as a vector containing the values of the endogenous treatment variable, or as a list where the first element is the vector of endogenous treatment values and the second element is a string containing the name of the statistic to be used. Allowed statistics are \code{ar} (Anderson-Rubin statistic) and \code{tsls} (2SLS statistic). Default statistic is \code{ar}. The \code{tsls} statistic relies on large-sample approximation.}

\item{d}{the effect size for asymptotic power calculation. Default is 0.5 * standard deviation of outcome variable for the control group.}

\item{dscale}{the fraction of the standard deviation of the outcome variable for the control group used as alternative hypothesis for asymptotic power calculation. Default is 0.5.}

\item{bernoulli}{the probabilities of treatment for each unit when assignment mechanism is a Bernoulli trial. This option should be specified as a vector of length equal to the length of the outcome and running variables.}

\item{quietly}{suppresses the output table.}

\item{covariates}{the covariates used by \code{rdwinselect} to choose the window when \code{wl} and \code{wr} are not specified. This should be a matrix of size n x k where n is the total sample size and k is the number of covariates.}

\item{obsmin}{the minimum number of observations above and below the cutoff in the smallest window employed by the companion command \code{rdwinselect}. Default is 10.}

\item{wmin}{the smallest window to be used (if \code{minobs} is not specified) by the companion command \code{rdwinselect}. Specifying both \code{wmin} and \code{obsmin} returns an error.}

\item{wobs}{the number of observations to be added at each side of the cutoff at each step.}

\item{wstep}{the increment in window length (if \code{obsstep} is not specified) by the companion command \code{rdwinselect}.  Specifying both \code{obsstep} and \code{wstep} returns an error.}

\item{nwindows}{the number of windows to be used by the companion command \code{rdwinselect}. Default is 10.}

\item{rdwstat}{the statistic to be used by the companion command \code{rdwinselect} (see corresponding help for options). Default option is \code{ttest}.}

\item{approx}{forces the companion command \code{rdwinselect} to conduct the covariate balance tests using a large-sample approximation instead of finite-sample exact randomization inference methods.}

\item{rdwreps}{the number of replications to be used by the companion command \code{rdwinselect}. Default is 1000.}

\item{level}{the minimum accepted value of the p-value from the covariate balance tests to be used by the companion command \code{rdwinselect}. Default is .15.}

\item{plot}{draws a scatter plot of the minimum p-value from the covariate balance test against window length implemented by the companion command \code{rdwinselect}.}

\item{obsstep}{the minimum number of observations to be added on each side of the cutoff for the sequence of fixed-increment nested windows. Default is 2. This option is deprecated and only included for backward compatibility.}
}
\value{
\item{sumstats}{summary statistics}
\item{obs.stat}{observed statistic(s)}
\item{p.value}{randomization p-value(s)}
\item{asy.pvalue}{asymptotic p-value(s)}
\item{window}{chosen window}
\item{ci}{confidence interval (only if \code{ci} option is specified)}
\item{interf.ci}{confidence interval under interferecen (only if \code{interfci} is specified)}
}
\description{
\code{rdrandinf} implements randomization inference and related methods for RD designs,
using observations in a specified or data-driven selected window around the cutoff where
local randomization is assumed to hold.
}
\examples{
# Toy dataset
X <- array(rnorm(200),dim=c(100,2))
R <- X[1,] + X[2,] + rnorm(100)
Y <- 1 + R -.5*R^2 + .3*R^3 + (R>=0) + rnorm(100)
# Randomization inference in window (-.75,.75)
tmp <- rdrandinf(Y,R,wl=-.75,wr=.75)
# Randomization inference in window (-.75,.75), all statistics
tmp <- rdrandinf(Y,R,wl=-.75,wr=.75,statistic='all')
# Randomization inference with window selection
# Note: low number of replications to speed up process.
# The user should increase the number of replications.
tmp <- rdrandinf(Y,R,statistic='all',covariates=X,wmin=.5,wstep=.125,rdwreps=500)



}
\references{
M.D. Cattaneo, B. Frandsen and R. Titiunik. (2015).  \href{https://sites.google.com/site/rdpackages/rdlocrand/Cattaneo-Frandsen-Titiunik_2015_JCI.pdf}{Randomization Inference in the Regression Discontinuity Design: An Application to Party Advantages in the U.S. Senate}. \emph{Journal of Causal Inference} 3(1): 1-24.

M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2016). \href{https://sites.google.com/site/rdpackages/rdlocrand/Cattaneo-Titiunik-VazquezBare_2016_Stata.pdf}{Inference in Regression Discontinuity Designs under Local Randomization}. \emph{Stata Journal} 16(2): 331-367.

M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2017). \href{https://sites.google.com/site/rdpackages/rdlocrand/Cattaneo-Titiunik-VazquezBare_2017_JPAM.pdf}{Comparing Inference Approaches for RD Designs: A Reexamination of the Effect of Head Start on Child Mortality}. \emph{Journal of Policy Analysis and Management} 36(3): 643-681.
}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}

Gonzalo Vazquez-Bare, UC Santa Barbara. \email{gvazquez@econ.ucsb.edu}
}
