% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProductPackageItemService.R
\name{dfp_getProductPackageItemsByStatement}
\alias{dfp_getProductPackageItemsByStatement}
\title{getProductPackageItemsByStatement}
\usage{
dfp_getProductPackageItemsByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getProductPackageItemsByStatementResponse
}
\description{
Gets a ProductPackageItemPage of ProductPackageItem objects that satisfy the filtering criteria specified by given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{productPackageId}
  \item{productId}
  \item{productTemplateId}
  \item{mandatory}
  \item{archived}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getProductPackageItemsByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/ProductPackageItemService#getProductPackageItemsByStatement}{Google Documentation for getProductPackageItemsByStatement}
}
