% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GammaDistribution.R
\docType{class}
\name{GammaDistribution}
\alias{GammaDistribution}
\title{A parametrized Gamma distribution}
\description{
An R6 class representing a Gamma distribution.
}
\details{
An object representing a Gamma distribution with hyperparameters 
shape (\code{k}) and scale (\code{theta}). In econometrics this
parametrization is more common but in Bayesian statistics the shape 
(\code{alpha}) and rate (\code{beta}) parametrization is more usual. Note, 
however, that although Briggs \emph{et al} (2006) use the shape, scale
formulation, they use \code{alpha}, \code{beta} as parameter names. Inherits
from class \code{Distribution}.
}
\references{
{
  Briggs A, Claxton K, Sculpher M. Decision modelling for health
  economic evaluation. Oxford, UK: Oxford University Press; 2006. 
}
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Distribution]{rdecision::Distribution}} -> \code{GammaDistribution}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GammaDistribution$new()}}
\item \href{#method-distribution}{\code{GammaDistribution$distribution()}}
\item \href{#method-mean}{\code{GammaDistribution$mean()}}
\item \href{#method-mode}{\code{GammaDistribution$mode()}}
\item \href{#method-SD}{\code{GammaDistribution$SD()}}
\item \href{#method-sample}{\code{GammaDistribution$sample()}}
\item \href{#method-quantile}{\code{GammaDistribution$quantile()}}
\item \href{#method-clone}{\code{GammaDistribution$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="order">}\href{../../rdecision/html/Distribution.html#method-order}{\code{rdecision::Distribution$order()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="r">}\href{../../rdecision/html/Distribution.html#method-r}{\code{rdecision::Distribution$r()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Distribution" data-id="varcov">}\href{../../rdecision/html/Distribution.html#method-varcov}{\code{rdecision::Distribution$varcov()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of class \code{GammaDistribution}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaDistribution$new(shape, scale)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{shape}}{shape parameter of the Gamma distribution.}

\item{\code{scale}}{scale parameter of the Gamma distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{GammaDistribution}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-distribution"></a>}}
\if{latex}{\out{\hypertarget{method-distribution}{}}}
\subsection{Method \code{distribution()}}{
Accessor function for the name of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaDistribution$distribution()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Distribution name as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mean"></a>}}
\if{latex}{\out{\hypertarget{method-mean}{}}}
\subsection{Method \code{mean()}}{
Return the expected value of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaDistribution$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Expected value as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mode"></a>}}
\if{latex}{\out{\hypertarget{method-mode}{}}}
\subsection{Method \code{mode()}}{
Return the mode of the distribution (if \code{shape} >= 1)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaDistribution$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
mode as a numeric value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SD"></a>}}
\if{latex}{\out{\hypertarget{method-SD}{}}}
\subsection{Method \code{SD()}}{
Return the standard deviation of the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaDistribution$SD()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Standard deviation as a numeric value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sample"></a>}}
\if{latex}{\out{\hypertarget{method-sample}{}}}
\subsection{Method \code{sample()}}{
Draw and hold a random sample from the distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaDistribution$sample(expected = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expected}}{If TRUE, sets the next value retrieved by a call to
\code{r()} to be the mean of the distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-quantile"></a>}}
\if{latex}{\out{\hypertarget{method-quantile}{}}}
\subsection{Method \code{quantile()}}{
Return the quantiles of the Gamma uncertainty distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaDistribution$quantile(probs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{probs}}{Vector of probabilities, in range [0,1].}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of quantiles.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GammaDistribution$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
