% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata.R
\name{get_osm_streets}
\alias{get_osm_streets}
\title{Get OpenStreetMap streets}
\usage{
get_osm_streets(aoi, crs = NULL, highway_values = NULL, force_download = FALSE)
}
\arguments{
\item{aoi}{Area of interest as sf object or bbox}

\item{crs}{Coordinate reference system as EPSG code}

\item{highway_values}{A character vector with the highway values to retrieve.
If left NULL, the function retrieves the following values:
"motorway", "trunk", "primary", "secondary", "tertiary"}

\item{force_download}{Download data even if cached data is available}
}
\value{
An sf object with the streets
}
\description{
Get OpenStreetMap streets
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bb <- get_osm_bb("Bucharest")
crs <- get_utm_zone(bb)
get_osm_streets(bb, crs)
\dontshow{\}) # examplesIf}
}
