% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwiseGeometric.r
\name{groupwiseGeometric}
\alias{groupwiseGeometric}
\title{Groupwise geometric means and confidence intervals}
\usage{
groupwiseGeometric(
  formula = NULL,
  data = NULL,
  var = NULL,
  group = NULL,
  conf = 0.95,
  na.rm = TRUE,
  digits = 3,
  ...
)
}
\arguments{
\item{formula}{A formula indicating the measurement variable and
the grouping variables. e.g. y ~ x1 + x2.}

\item{data}{The data frame to use.}

\item{var}{The measurement variable to use. The name is in double quotes.}

\item{group}{The grouping variable to use. The name is in double quotes.
Multiple names are listed as a vector. (See example.)}

\item{conf}{The confidence interval to use.}

\item{na.rm}{If \code{TRUE}, removes NA values in the measurement variable.}

\item{digits}{The number of significant figures to use in output.}

\item{...}{Other arguments.  Not currently useful.}
}
\value{
A data frame of geometric means, standard deviations, standard 
        errors, and confidence intervals.
}
\description{
Calculates geometric means and confidence intervals for
             groups.
}
\details{
The input should include either \code{formula} and \code{data};
             or \code{data}, \code{var}, and \code{group}. (See examples).

         The function computes means, standard deviations, standard errors, 
         and confidence intervals on log-transformed values. Confidence
         intervals are calculated in the traditional
         manner with the t-distribution.  These statistics assume that
         the data are log-normally distributed. For data not meeting this
         assumption, medians and confidence intervals by bootstrap may be more 
         appropriate.
}
\note{
The parsing of the formula is simplistic. The first variable on the
         left side is used as the measurement variable.  The variables on the
         right side are used for the grouping variables.
         
       Results for ungrouped (one-sample) data can be obtained by either
         setting the right side of the formula to 1, e.g.  y ~ 1, or by
         setting \code{group=NULL}.
}
\examples{
### Example with formula notation 
data(Catbus)
groupwiseGeometric(Steps ~ Sex + Teacher,
                   data   = Catbus)

### Example with variable notation                                              
data(Catbus)
groupwiseGeometric(data   = Catbus,
                   var    = "Steps",
                   group  = c("Sex", "Teacher"))
                      
}
\references{
\url{http://rcompanion.org/handbook/C_03.html}
}
\seealso{
\code{\link{groupwiseMean}}, \code{\link{groupwiseMedian}}
         \code{\link{groupwiseHuber}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{geometric mean confidence interval standard deviation error}
