% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nagelkerkeHermite.r
\name{nagelkerkeHermite}
\alias{nagelkerkeHermite}
\title{Pseudo r-squared measures for hermite models}
\usage{
nagelkerkeHermite(fit, null)
}
\arguments{
\item{fit}{The fitted model object for which to determine pseudo r-squared.}

\item{null}{The null model object against which to compare the fitted model 
object. The null model must be nested in the fitted model to be 
valid.}
}
\value{
A list of four objects describing the models used, the pseudo 
        r-squared values, the likelihood ratio test for the model, and AIC
        for the fitted and null models.
}
\description{
Produces McFadden, Cox and Snell, and Nagelkerke pseudo 
             R-squared measures, along with p-value for the model, 
             for hermite regression objects.
}
\details{
Hermite regression is performed with the \code{hermite} package.
          
          For pseudo r-squared measures, Cox and Snell is also referred to 
          as ML. Nagelkerke is also referred to as Cragg and Uhler.
}
\examples{
data(Monarchs)
library(hermite)
model = glm.hermite(Monarchs ~ Garden,
                    data = Monarchs,
                    link = "log",
                    m=3)
null = glm.hermite(Monarchs ~ 1,
                   data = Monarchs,
                   link = "log",
                   m=3)
nagelkerkeHermite(model, null)

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/J_01.html}
}
\seealso{
\code{\link{nagelkerke}}
}
\concept{
pseudo r-squared cox snell nagelkerke likelihood hermite
}

