% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseMedianMatrix.r
\name{pairwiseMedianMatrix}
\alias{pairwiseMedianMatrix}
\title{Pairwise Mood's median tests with matrix output}
\usage{
pairwiseMedianMatrix(x, g, exact = NULL, method = "fdr", ...)
}
\arguments{
\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{exact}{If \code{TRUE}, then asks the \code{mood.medtest} function
to conduct an exact test. If \code{NULL}, then uses an 
exact test if the number of values is less than 200.
See \code{\link{mood.medtest}}.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{\link{p.adjust}}.}

\item{...}{Additional arguments passed to
\code{\link{mood.medtest}}.}
}
\value{
A list consisting of:
        a matrix of p-values;
        the p-value adjustment method;
        a matrix of adjusted p-values.
}
\description{
Conducts pairwise Mood's median tests across groups.
}
\details{
Mood's median test compares medians among two or more groups.
         See \url{http://rcompanion.org/handbook/F_09.html} for
         futher discussion of this test.

         The \code{pairwiseMedianMatrix} function
         can be used as a post-hoc method following an omnibus Mood's
         median test.
         The matrix output can be converted to a compact letter display.
}
\examples{
data(PoohPiglet)
PoohPiglet$Speaker = factor(PoohPiglet$Speaker, 
                            levels=c("Pooh", "Tigger", "Piglet"))               
PT = pairwiseMedianMatrix(x      = PoohPiglet$Likert,
                          g      = PoohPiglet$Speaker,
                          exact  = NULL,
                          method = "fdr")$Adjusted
PT                           
library(multcompView)
multcompLetters(PT,
                compare="<",
                threshold=0.05,
                Letters=letters)                    

}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/F_09.html}
}
\seealso{
\code{\link{pairwiseMedianTest}}
}
\concept{
moods median nonparametric post-hoc one-way cld
}

