% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-eca_gsl.R, R/family-ecagsl.R
\name{cdo_eca_gsl}
\alias{cdo_eca_gsl}
\alias{ecagsl}
\title{Thermal Growing season length index}
\usage{
cdo_eca_gsl(ifile1, ifile2, nday = NULL, T = NULL, fland = NULL, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{nday}{INTEGER - Number of consecutive days (default: nday = 6)}

\item{T}{FLOAT - Temperature threshold (unit: °C; default: T = 5°C)}

\item{fland}{FLOAT - Land fraction threshold (default: fland = 0.5)}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
Let infile1 be a time series of the daily mean temperature TG, and infile2 be a land-water mask. Within a period of 12 months, the thermal growing season length is officially defined as the number of days between: - first occurrence of at least nday consecutive days with TG > T - first occurrence of at least nday consecutive days with TG < T within the last 6 months On northern hemisphere, this period corresponds with the regular year, whereas on southern hemisphere, it starts at July 1st. Please note, that this definition may lead to weird results concerning values TG = T: In the first half of the period, these days do not contribute to the gsl, but they do within the second half. Moreover this definition could lead to discontinuous values in equatorial regions.  The numbers nday and T are optional parameter with default nday = 6 and T = 5°C. The number fland is an optional parameter with default value fland = 0.5 and denotes the fraction of a grid point that have to be covered by land in order to be included in the calculation. A further output variable is the start day of year of the growing season. Note that TG have to be given in units of Kelvin, whereas T have to be given in degrees Celsius.  The date information of a timestep in outfile is the date of the last contributing timestep in infile.
}
