% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-eq.R, R/cdo-ge.R, R/cdo-gt.R, R/cdo-le.R,
%   R/cdo-lt.R, R/cdo-ne.R, R/family-comp.R
\name{cdo_eq}
\alias{cdo_eq}
\alias{cdo_ge}
\alias{cdo_gt}
\alias{cdo_le}
\alias{cdo_lt}
\alias{cdo_ne}
\alias{comp}
\title{Comparison of two fields}
\usage{
cdo_eq(ifile1, ifile2, ofile = NULL)

cdo_ge(ifile1, ifile2, ofile = NULL)

cdo_gt(ifile1, ifile2, ofile = NULL)

cdo_le(ifile1, ifile2, ofile = NULL)

cdo_lt(ifile1, ifile2, ofile = NULL)

cdo_ne(ifile1, ifile2, ofile = NULL)
}
\arguments{
\item{ifile1, ifile2}{Strings with the path to the input files.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module compares two datasets field by field. The resulting field is a mask containing 1 if the comparison is true and 0 if not. The number of fields in infile1 should be the same as in infile2. One of the input files can contain only one timestep or one field. The fields in outfile inherit the meta data from infile1 or infile2. The type of comparison depends on the chosen operator.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{eq  Equal
              /   1   if i_1(t,x) EQ i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
    o(t,x) = &lt;    0   if i_1(t,x) NE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
              \\\\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss
ne  Not equal
              /   1   if i_1(t,x) NE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
    o(t,x) = &lt;    0   if i_1(t,x) EQ i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
              \\\\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss
le  Less equal
              /   1   if i_1(t,x) LE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
    o(t,x) = &lt;    0   if i_1(t,x) GT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
              \\\\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss
lt  Less than
              /   1   if i_1(t,x) LT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
    o(t,x) = &lt;    0   if i_1(t,x) GE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
              \\\\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss
ge  Greater equal
              /   1   if i_1(t,x) GE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
    o(t,x) = &lt;    0   if i_1(t,x) LT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
              \\\\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss
gt  Greater than
              /   1   if i_1(t,x) GT i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
    o(t,x) = &lt;    0   if i_1(t,x) LE i_2(t,x)  AND  i_1(t,x),i_2(t,x) NE miss
              \\\\  miss if i_1(t,x) EQ miss      OR   i_2(t,x) EQ miss
}\if{html}{\out{</div>}}
}
