/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.InvalidSmilesException;

final class RemoveUpDownBonds
extends AbstractFunction<Graph, Graph> {
    RemoveUpDownBonds() {
    }

    public Graph apply(Graph g) throws InvalidSmilesException {
        Graph h = new Graph(g.order());
        for (int u = 0; u < g.order(); ++u) {
            h.addAtom(g.atom(u));
            h.addTopology(g.topologyOf(u));
        }
        int[] ordering = new DepthFirstOrder(g).visited;
        HashMap<Edge, Edge> replacements = new HashMap<Edge, Edge>();
        TreeSet<Integer> dbCentres = new TreeSet<Integer>();
        for (int u = 0; u < g.order(); ++u) {
            for (Edge e : g.edges(u)) {
                if (e.other(u) <= u || e.bond() != Bond.DOUBLE) continue;
                this.removeRedundant(g, e, ordering, replacements);
                dbCentres.add(u);
                dbCentres.add(e.other(u));
            }
        }
        for (Edge e : new HashSet(replacements.keySet())) {
            if (!dbCentres.contains(e.either()) || !dbCentres.contains(e.other(e.either()))) continue;
            replacements.remove(e);
        }
        for (int u = 0; u < g.order(); ++u) {
            for (Edge e : g.edges(u)) {
                if (e.other(u) <= u) continue;
                Edge replacement = (Edge)replacements.get(e);
                if (replacement != null) {
                    e = replacement;
                }
                h.addEdge(e);
            }
        }
        return h;
    }

    private void removeRedundant(Graph g, Edge e, int[] ordering, Map<Edge, Edge> acc) throws InvalidSmilesException {
        int u = e.either();
        int v = e.other(u);
        this.replaceImplWithExpl(g, e, u, ordering, acc);
        this.replaceImplWithExpl(g, e, v, ordering, acc);
    }

    private void replaceImplWithExpl(Graph g, Edge e, final int u, final int[] ordering, Map<Edge, Edge> acc) throws InvalidSmilesException {
        TreeSet<Edge> edges = new TreeSet<Edge>(Collections.reverseOrder(new Comparator<Edge>(){

            @Override
            public int compare(Edge e, Edge f) {
                int w;
                int v = ordering[e.other(u)];
                if (v > (w = ordering[f.other(u)])) {
                    return 1;
                }
                if (v < w) {
                    return -1;
                }
                return 0;
            }
        }));
        for (Edge f : g.edges(u)) {
            switch (f.bond()) {
                case DOUBLE: {
                    if (f.equals((Object)e)) break;
                    return;
                }
                case UP: 
                case DOWN: {
                    edges.add(f);
                }
            }
        }
        if (edges.size() == 2) {
            Iterator it = edges.iterator();
            Edge explicit = (Edge)it.next();
            int v = explicit.either();
            int w = explicit.other(v);
            acc.put(explicit, new Edge(v, w, Bond.IMPLICIT));
        } else if (edges.size() > 2) {
            throw new InvalidSmilesException("Too many up/down bonds on double bonded atom");
        }
    }

    private static final class DepthFirstOrder {
        private final Graph g;
        private final int[] visited;
        private int i;

        private DepthFirstOrder(Graph g) {
            this.g = g;
            this.visited = new int[g.order()];
            Arrays.fill(this.visited, -1);
            for (int u = 0; u < g.order(); ++u) {
                if (this.visited[u] >= 0) continue;
                this.visit(u);
            }
        }

        private void visit(int u) {
            ++this.i;
            for (Edge e : this.g.edges(u)) {
                int v = e.other(u);
                if (this.visited[v] >= 0) continue;
                this.visit(v);
            }
        }
    }
}

