/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.InvPair;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

@TestClass(value="org.openscience.cdk.graph.invariant.CanonicalLabelerTest")
@Deprecated
public class CanonicalLabeler {
    @TestMethod(value="testCanonLabel_IAtomContainer,testSomeMoleculeWithDifferentStartingOrder")
    public synchronized void canonLabel(IAtomContainer atomContainer) {
        if (atomContainer.getAtomCount() == 0) {
            return;
        }
        if (atomContainer.getAtomCount() == 1) {
            atomContainer.getAtom(0).setProperty((Object)"CanonicalLabel", (Object)1);
        }
        List<InvPair> vect = this.createInvarLabel(atomContainer);
        this.step3(vect, atomContainer);
    }

    private void step2(List<InvPair> v, IAtomContainer atoms) {
        this.primeProduct(v, atoms);
        this.step3(v, atoms);
    }

    private void step3(List<InvPair> v, IAtomContainer atoms) {
        this.sortArrayList(v);
        this.rankArrayList(v);
        if (!this.isInvPart(v)) {
            this.step2(v, atoms);
        } else {
            if (v.get(v.size() - 1).getCurr() < (long)v.size()) {
                this.breakTies(v);
                this.step2(v, atoms);
            }
            for (InvPair aV : v) {
                aV.commit();
            }
        }
    }

    private List<InvPair> createInvarLabel(IAtomContainer atomContainer) {
        Iterator atoms = atomContainer.atoms().iterator();
        ArrayList<InvPair> vect = new ArrayList<InvPair>();
        while (atoms.hasNext()) {
            IAtom a = (IAtom)atoms.next();
            StringBuffer inv = new StringBuffer();
            inv.append(atomContainer.getConnectedAtomsList(a).size() + (a.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : a.getImplicitHydrogenCount()));
            inv.append(atomContainer.getConnectedAtomsList(a).size());
            inv.append(PeriodicTable.getAtomicNumber((String)a.getSymbol()));
            Double charge = a.getCharge();
            if (charge == CDKConstants.UNSET) {
                charge = 0.0;
            }
            if (charge < 0.0) {
                inv.append(1);
            } else {
                inv.append(0);
            }
            inv.append((int)Math.abs(a.getFormalCharge() == CDKConstants.UNSET ? 0.0 : (double)a.getFormalCharge().intValue()));
            inv.append(a.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : a.getImplicitHydrogenCount());
            vect.add(new InvPair(Long.parseLong(inv.toString()), a));
        }
        return vect;
    }

    private void primeProduct(List<InvPair> v, IAtomContainer atomContainer) {
        for (InvPair inv : v) {
            List neighbour = atomContainer.getConnectedAtomsList(inv.getAtom());
            Iterator n = neighbour.iterator();
            long summ = 1L;
            while (n.hasNext()) {
                IAtom a = (IAtom)n.next();
                int next = ((InvPair)a.getProperty((Object)"InvariancePair")).getPrime();
                summ *= (long)next;
            }
            inv.setLast(inv.getCurr());
            inv.setCurr(summ);
        }
    }

    private void sortArrayList(List<InvPair> v) {
        Collections.sort(v, new Comparator<InvPair>(){

            @Override
            public int compare(InvPair o1, InvPair o2) {
                if (o1.getCurr() > o2.getCurr()) {
                    return 1;
                }
                if (o1.getCurr() < o2.getCurr()) {
                    return -1;
                }
                return 0;
            }
        });
        Collections.sort(v, new Comparator<InvPair>(){

            @Override
            public int compare(InvPair o1, InvPair o2) {
                if (o1.getLast() > o2.getLast()) {
                    return 1;
                }
                if (o1.getLast() < o2.getLast()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private void rankArrayList(List<InvPair> v) {
        InvPair curr;
        int num = 1;
        int[] temp = new int[v.size()];
        InvPair last = v.get(0);
        Iterator<InvPair> it = v.iterator();
        int x = 0;
        while (it.hasNext()) {
            curr = it.next();
            if (!last.equals(curr)) {
                // empty if block
            }
            temp[x] = ++num;
            last = curr;
            ++x;
        }
        it = v.iterator();
        x = 0;
        while (it.hasNext()) {
            curr = it.next();
            curr.setCurr(temp[x]);
            curr.setPrime();
            ++x;
        }
    }

    private boolean isInvPart(List<InvPair> v) {
        if (v.get(v.size() - 1).getCurr() == (long)v.size()) {
            return true;
        }
        for (InvPair curr : v) {
            if (curr.getCurr() == curr.getLast()) continue;
            return false;
        }
        return true;
    }

    private void breakTies(List<InvPair> v) {
        InvPair curr;
        Iterator<InvPair> it = v.iterator();
        InvPair last = null;
        int tie = 0;
        boolean found = false;
        int x = 0;
        while (it.hasNext()) {
            curr = it.next();
            curr.setCurr(curr.getCurr() * 2L);
            curr.setPrime();
            if (x != 0 && !found && curr.getCurr() == last.getCurr()) {
                tie = x - 1;
                found = true;
            }
            last = curr;
            ++x;
        }
        curr = v.get(tie);
        curr.setCurr(curr.getCurr() - 1L);
        curr.setPrime();
    }
}

