/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.EuclidConstants;

public abstract class Real
implements EuclidConstants {
    static final Logger logger = Logger.getLogger((String)Real.class.getName());
    static double epsx = 1.0E-10;
    public static final String SCIENTIFIC_PARSE = "(?:[+-]?(?:(?:\\d*(?:\\.?\\d+)?)|(?:\\d+(?:\\.?\\d*)?))(?:[EeDdGgHh][+-]?\\d+[dDfF]?)?)";
    public static final Pattern SCIENTIFIC_PATTERN = Pattern.compile("(?:[+-]?(?:(?:\\d*(?:\\.?\\d+)?)|(?:\\d+(?:\\.?\\d*)?))(?:[EeDdGgHh][+-]?\\d+[dDfF]?)?)");

    public static double getEpsilon() {
        return epsx;
    }

    public static void setEpsilon(double epsilon) {
        epsx = epsilon;
    }

    public static double normalize(double d, int ndec) {
        int dd = 1;
        for (int i = 0; i < ndec; ++i) {
            dd *= 10;
        }
        return (double)Math.round(d * (double)dd) / (double)dd;
    }

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) < epsx;
    }

    public static boolean isZero(double a) {
        return Real.isZero(a, epsx);
    }

    public static boolean isEqual(int n, double[] a, double[] b, double epsilon) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Real.isEqual(a[i], b[i], epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(double[] a, double[] b, double epsilon) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Real.isEqual(a[i], b[i], epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(int n, double[] a, double[] b) {
        return Real.isEqual(n, a, b, epsx);
    }

    public static boolean isEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static double parseDouble(String db) {
        double d = Double.NaN;
        db = db.trim();
        try {
            d = Double.parseDouble(db);
        }
        catch (NumberFormatException nfe) {
            d = Double.parseDouble(db.replaceFirst("[DdGgHh]", "E"));
        }
        if (d == Double.NaN) {
            throw new RuntimeException("Cannot parse {" + db + "} as double and cannot throw NumberFormatException. This is a program bug.");
        }
        return d;
    }

    public static boolean isZero(double a, double epsilon) {
        return Math.abs(a) < epsilon;
    }

    public static boolean isLessThan(double a, double b) {
        return b - a > epsx;
    }

    public static boolean isGreaterThan(double a, double b) {
        return a - b > epsx;
    }

    public static void zeroArray(int nelem, double[] arr) {
        for (int i = 0; i < nelem; ++i) {
            arr[i] = 0.0;
        }
    }

    public static void initArray(int nelem, double[] arr, double f) {
        for (int i = 0; i < nelem; ++i) {
            arr[i] = f;
        }
    }

    public static void printArray(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            logger.info((Object)(a[i] + " "));
        }
        logger.info((Object)"");
    }
}

