/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import org.openscience.cdk.AminoAcid;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.AtomContainerSet;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.BioPolymer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.DynamicFactory;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.Element;
import org.openscience.cdk.FragmentAtom;
import org.openscience.cdk.Isotope;
import org.openscience.cdk.LonePair;
import org.openscience.cdk.Mapping;
import org.openscience.cdk.Monomer;
import org.openscience.cdk.Polymer;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.ReactionScheme;
import org.openscience.cdk.ReactionSet;
import org.openscience.cdk.Ring;
import org.openscience.cdk.RingSet;
import org.openscience.cdk.SingleElectron;
import org.openscience.cdk.Strand;
import org.openscience.cdk.Substance;
import org.openscience.cdk.formula.AdductFormula;
import org.openscience.cdk.formula.MolecularFormula;
import org.openscience.cdk.formula.MolecularFormulaSet;
import org.openscience.cdk.interfaces.IAdductFormula;
import org.openscience.cdk.interfaces.IAminoAcid;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBioPolymer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ICDKObject;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IFragmentAtom;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPDBAtom;
import org.openscience.cdk.interfaces.IPDBMonomer;
import org.openscience.cdk.interfaces.IPDBPolymer;
import org.openscience.cdk.interfaces.IPDBStructure;
import org.openscience.cdk.interfaces.IPolymer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionScheme;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.interfaces.ISubstance;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.protein.data.PDBAtom;
import org.openscience.cdk.protein.data.PDBMonomer;
import org.openscience.cdk.protein.data.PDBPolymer;
import org.openscience.cdk.protein.data.PDBStructure;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.TetrahedralChirality;

public class DefaultChemObjectBuilder
implements IChemObjectBuilder {
    private static volatile IChemObjectBuilder instance = null;
    private static final Object lock = new Object();
    private final DynamicFactory factory = new DynamicFactory(200);

    private DefaultChemObjectBuilder() {
        final DefaultChemObjectBuilder self = this;
        this.factory.register(IAtom.class, Atom.class);
        this.factory.register(IPseudoAtom.class, PseudoAtom.class);
        this.factory.register(IElement.class, Element.class);
        this.factory.register(IAtomType.class, AtomType.class);
        this.factory.register(IFragmentAtom.class, FragmentAtom.class);
        this.factory.register(IPDBAtom.class, PDBAtom.class);
        this.factory.register(IIsotope.class, Isotope.class);
        this.factory.register(IBond.class, Bond.class);
        this.factory.register(IElectronContainer.class, ElectronContainer.class);
        this.factory.register(ISingleElectron.class, SingleElectron.class);
        this.factory.register(ILonePair.class, LonePair.class);
        this.factory.register(IAtomContainer.class, AtomContainer.class);
        this.factory.register(IRing.class, Ring.class);
        this.factory.register(ICrystal.class, Crystal.class);
        this.factory.register(IPolymer.class, Polymer.class);
        this.factory.register(IPDBPolymer.class, PDBPolymer.class);
        this.factory.register(IMonomer.class, Monomer.class);
        this.factory.register(IPDBMonomer.class, PDBMonomer.class);
        this.factory.register(IBioPolymer.class, BioPolymer.class);
        this.factory.register(IPDBStructure.class, PDBStructure.class);
        this.factory.register(IAminoAcid.class, AminoAcid.class);
        this.factory.register(IStrand.class, Strand.class);
        this.factory.register(IReaction.class, Reaction.class);
        this.factory.register(IReactionScheme.class, ReactionScheme.class);
        this.factory.register(IMolecularFormula.class, MolecularFormula.class);
        this.factory.register(IAdductFormula.class, AdductFormula.class);
        this.factory.register(IAtomContainerSet.class, AtomContainerSet.class);
        this.factory.register(IMolecularFormulaSet.class, MolecularFormulaSet.class);
        this.factory.register(IReactionSet.class, ReactionSet.class);
        this.factory.register(IRingSet.class, RingSet.class);
        this.factory.register(IChemModel.class, ChemModel.class);
        this.factory.register(IChemFile.class, ChemFile.class);
        this.factory.register(IChemSequence.class, ChemSequence.class);
        this.factory.register(ISubstance.class, Substance.class);
        this.factory.register(ITetrahedralChirality.class, TetrahedralChirality.class, (DynamicFactory.CreationModifier)new DynamicFactory.CreationModifier<TetrahedralChirality>(){

            public void modify(TetrahedralChirality instance) {
                instance.setBuilder(self);
            }
        });
        this.factory.register(IDoubleBondStereochemistry.class, DoubleBondStereochemistry.class, (DynamicFactory.CreationModifier)new DynamicFactory.CreationModifier<DoubleBondStereochemistry>(){

            public void modify(DoubleBondStereochemistry instance) {
                instance.setBuilder(self);
            }
        });
        this.factory.register(IMapping.class, Mapping.class);
        this.factory.register(IChemObject.class, ChemObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IChemObjectBuilder getInstance() {
        IChemObjectBuilder result = instance;
        if (result == null) {
            result = instance;
            Object object = lock;
            synchronized (object) {
                if (result == null) {
                    instance = result = new DefaultChemObjectBuilder();
                }
            }
        }
        return result;
    }

    public <T extends ICDKObject> T newInstance(Class<T> clazz, Object ... params) {
        return (T)this.factory.ofClass(clazz, params);
    }
}

