/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.elements;

import java.awt.Color;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;
import org.openscience.cdk.renderer.elements.LineElement;

@TestClass(value="org.openscience.cdk.renderer.elements.WedgeLineElementTest")
public class WedgeLineElement
extends LineElement {
    public final TYPE type;
    public final Direction direction;

    @TestMethod(value="testConstructor")
    public WedgeLineElement(double x1, double y1, double x2, double y2, double width, TYPE type, Direction direction, Color color) {
        super(x1, y1, x2, y2, width, color);
        this.type = type;
        this.direction = direction;
    }

    @TestMethod(value="testConstructor_LineElement")
    public WedgeLineElement(LineElement element, TYPE type, Direction direction, Color color) {
        this(direction == Direction.toFirst ? element.secondPointX : element.firstPointX, direction == Direction.toFirst ? element.secondPointY : element.firstPointY, direction == Direction.toFirst ? element.firstPointX : element.secondPointX, direction == Direction.toFirst ? element.firstPointY : element.secondPointY, element.width, type, direction, color);
    }

    @Override
    @TestMethod(value="testAccept")
    public void accept(IRenderingVisitor v) {
        v.visit((IRenderingElement)this);
    }

    public static enum Direction {
        toFirst,
        toSecond;

    }

    public static enum TYPE {
        DASHED,
        WEDGED,
        INDIFF;

    }
}

