/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.reaction.mechanism.RemovingSEofNBMechanismTest")
public class RemovingSEofNBMechanism
implements IReactionMechanism {
    @Override
    @TestMethod(value="testInitiate_IAtomContainerSet_ArrayList_ArrayList")
    public IReaction initiate(IAtomContainerSet atomContainerSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IAtomContainer reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)atomContainerSet.getBuilder());
        if (atomContainerSet.getAtomContainerCount() != 1) {
            throw new CDKException("RemovingSEofNBMechanism only expects one IMolecule");
        }
        if (atomList.size() != 1) {
            throw new CDKException("RemovingSEofNBMechanism only expects one atom in the ArrayList");
        }
        if (bondList != null) {
            throw new CDKException("RemovingSEofNBMechanism don't expect any bond in the ArrayList");
        }
        IAtomContainer molecule = atomContainerSet.getAtomContainer(0);
        try {
            reactantCloned = molecule.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IMolecule!", (Throwable)e);
        }
        int posAtom = molecule.getAtomNumber(atomList.get(0));
        List lps = reactantCloned.getConnectedLonePairsList(reactantCloned.getAtom(posAtom));
        reactantCloned.removeLonePair((ILonePair)lps.get(lps.size() - 1));
        reactantCloned.addSingleElectron((ISingleElectron)molecule.getBuilder().newInstance(ISingleElectron.class, new Object[]{reactantCloned.getAtom(posAtom)}));
        int charge = reactantCloned.getAtom(posAtom).getFormalCharge();
        reactantCloned.getAtom(posAtom).setFormalCharge(Integer.valueOf(charge + 1));
        reactantCloned.getAtom(posAtom).setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)reactantCloned);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, reactantCloned.getAtom(posAtom));
        if (type == null || type.getAtomTypeName().equals("X")) {
            return null;
        }
        IReaction reaction = (IReaction)molecule.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule);
        for (IAtom atom : molecule.atoms()) {
            IMapping mapping = (IMapping)molecule.getBuilder().newInstance(IMapping.class, new Object[]{atom, reactantCloned.getAtom(molecule.getAtomNumber(atom))});
            reaction.addMapping(mapping);
        }
        reaction.addProduct(reactantCloned);
        return reaction;
    }
}

