/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Comment;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.XPathContext;
import nu.xom.canonical.Canonicalizer;
import org.apache.log4j.Logger;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.XMLReader;
import org.xmlcml.cml.base.CMLBuilder;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLNamespace;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.euclid.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMLUtil
implements CMLConstants {
    private static final String DUMMY = "dummy";
    private static Logger LOG = Logger.getLogger(CMLUtil.class);
    public static final String DTD = ".dtd\">";

    public static final void checkPrefixedName(String name) {
        if (name == null || name.indexOf(":") < 1) {
            throw new RuntimeException("Unprefixed name (" + name + ")");
        }
    }

    public static String getPrefix(String s) {
        int idx = s.indexOf(":");
        return idx == -1 ? "" : s.substring(0, idx);
    }

    public static String getLocalName(String s) {
        String ss = null;
        if (s != null) {
            int idx = s.indexOf(":");
            ss = idx == -1 ? s : s.substring(idx + 1);
        }
        return ss;
    }

    public static String getSingleValue(Element element, String xpath, XPathContext xPathContext) {
        String s = null;
        if (element == null) {
            LOG.warn((Object)"Null element");
        } else {
            Nodes nodes = element.query(xpath, xPathContext);
            s = nodes.size() == 1 ? nodes.get(0).getValue() : null;
        }
        return s;
    }

    public static String getSingleValue(Element element, String xpath) {
        String s = null;
        if (element == null) {
            LOG.warn((Object)"Null element");
        } else {
            Nodes nodes = element.query(xpath);
            s = nodes.size() == 1 ? nodes.get(0).getValue() : null;
        }
        return s;
    }

    public static String getFirstValue(Element element, String xpath, XPathContext xPathContext) {
        String s = null;
        if (element == null) {
            LOG.warn((Object)"Null element");
        } else {
            Nodes nodes = element.query(xpath, xPathContext);
            s = nodes.size() >= 1 ? nodes.get(0).getValue() : null;
        }
        return s;
    }

    public static Element getSingleElement(Element element, String xpath, XPathContext xPathContext) {
        Nodes nodes = element.query(xpath, xPathContext);
        return nodes.size() == 1 ? (Element)nodes.get(0) : null;
    }

    public static List<CMLElement> getCMLElements(Element node, String xpath, XPathContext context) {
        ArrayList<CMLElement> nodeList = new ArrayList<CMLElement>();
        if (node != null) {
            Nodes nodes = node.query(xpath, context);
            for (int i = 0; i < nodes.size(); ++i) {
                if (!(nodes.get(i) instanceof CMLElement)) continue;
                nodeList.add((CMLElement)nodes.get(i));
            }
        }
        return nodeList;
    }

    public static final Object[] toArray(Elements elements, Object[] obj) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < elements.size(); ++i) {
            list.add(elements.get(i));
        }
        return list.toArray(obj);
    }

    public static void debug(Element el) {
        try {
            CMLUtil.debug(el, System.out, 2);
        }
        catch (IOException e) {
            throw new RuntimeException("BUG " + e);
        }
    }

    public static void debugToErr(Element el) {
        try {
            CMLUtil.debug(el, System.err, 2);
        }
        catch (IOException e) {
            throw new RuntimeException("BUG " + e);
        }
    }

    public static void debug(Element el, String message) {
        Util.println((String)(">>>>" + message + ">>>>"));
        CMLUtil.debug(el);
        Util.println((String)("<<<<" + message + "<<<<"));
    }

    public static void debug(Element el, OutputStream os, int indent) throws IOException {
        if (el != null) {
            Document document;
            ParentNode parent = el.getParent();
            if (parent instanceof Document) {
                document = (Document)parent;
            } else {
                Element copyElem = new Element(el);
                document = new Document(copyElem);
            }
            Serializer serializer = new Serializer(os, "UTF-8");
            if (indent >= 0) {
                serializer.setIndent(indent);
            }
            serializer.write(document);
        }
    }

    public static Document getXMLResource(String filename) throws IOException {
        Document document = null;
        InputStream in = null;
        try {
            in = Util.getInputStreamFromResource((String)filename);
            document = new Builder().build(in);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("" + e + " in " + filename);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return document;
    }

    public static List<Node> getChildNodes(Element el) {
        ArrayList<Node> childs = new ArrayList<Node>();
        if (el != null) {
            for (int i = 0; i < el.getChildCount(); ++i) {
                childs.add(el.getChild(i));
            }
        }
        return childs;
    }

    public static Element parseXML(String xmlString) throws RuntimeException {
        Element root = null;
        try {
            Document doc = new Builder().build((Reader)new StringReader(xmlString));
            root = doc.getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return root;
    }

    public static Document parseHtmlWithTagSoup(InputStream is) {
        try {
            Builder builder = CMLUtil.getTagsoupBuilder();
            return builder.build(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception whilse parsing XML, due to: " + e.getMessage(), e);
        }
    }

    public static Document parseHtmlWithTagSoup(File file) {
        try {
            return CMLUtil.parseHtmlWithTagSoup(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Exception whilse parsing HTML, due to: " + e.getMessage(), e);
        }
    }

    public static Builder getTagsoupBuilder() {
        Parser tagsoup = null;
        tagsoup = new Parser();
        return new Builder((XMLReader)tagsoup);
    }

    public static CMLElement parseCML(String cmlString) throws RuntimeException {
        CMLElement root = null;
        try {
            Document doc = new CMLBuilder().build(new StringReader(cmlString));
            root = (CMLElement)doc.getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return root;
    }

    public static List<Node> getQueryNodes(Node node, String xpath, XPathContext context) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        if (node != null) {
            Nodes nodes = node.query(xpath, context);
            for (int i = 0; i < nodes.size(); ++i) {
                nodeList.add(nodes.get(i));
            }
        }
        return nodeList;
    }

    public static List<Node> getQueryNodes(Node node, String xpath) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        if (node != null) {
            Nodes nodes = node.query(xpath);
            for (int i = 0; i < nodes.size(); ++i) {
                nodeList.add(nodes.get(i));
            }
        }
        return nodeList;
    }

    public static Node getFollowingSibling(Node current) {
        int index;
        ParentNode parent;
        Node node = null;
        if (current != null && (parent = current.getParent()) != null && (index = parent.indexOf(current)) + 1 < parent.getChildCount()) {
            node = parent.getChild(index + 1);
        }
        return node;
    }

    public static Node getPrecedingSibling(Node current) {
        int index;
        ParentNode parent;
        Node node = null;
        if (current != null && (parent = current.getParent()) != null && (index = parent.indexOf(current)) > 0) {
            node = parent.getChild(index - 1);
        }
        return node;
    }

    public static Text getLastTextDescendant(Node node) {
        List<Node> l = CMLUtil.getQueryNodes(node, ".//text() | self::text()");
        return l.size() == 0 ? null : (Text)l.get(l.size() - 1);
    }

    public static Text getFirstTextDescendant(Node node) {
        List<Node> l = CMLUtil.getQueryNodes(node, ".//text() | self::text()");
        return l.size() == 0 ? null : (Text)l.get(0);
    }

    public static void transferChildren(Element from, Element to) {
        int nc = from.getChildCount();
        int tc = to.getChildCount();
        for (int i = nc - 1; i >= 0; --i) {
            Node child = from.getChild(i);
            child.detach();
            to.insertChild(child, tc);
        }
    }

    public static void copyAttributes(Element from, Element to) {
        int natt = from.getAttributeCount();
        for (int i = 0; i < natt; ++i) {
            Attribute newAtt = new Attribute(from.getAttribute(i));
            to.addAttribute(newAtt);
        }
    }

    public static String getCanonicalString(Node node) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Canonicalizer canon = new Canonicalizer((OutputStream)baos);
        try {
            canon.write(node);
        }
        catch (IOException e) {
            throw new RuntimeException("should never throw " + e);
        }
        return baos.toString();
    }

    public static void removeWhitespaceNodes(Element element) {
        int nChild = element.getChildCount();
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (int i = 0; i < nChild; ++i) {
            Node node = element.getChild(i);
            if (node instanceof Text) {
                if (node.getValue().trim().length() != 0) continue;
                nodeList.add(node);
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            CMLUtil.removeWhitespaceNodes(childElement);
        }
        for (Node node : nodeList) {
            node.detach();
        }
    }

    public static void setXMLContent(Element element, String s) {
        List<Node> elements = CMLUtil.getQueryNodes((Node)element, "*");
        if (elements.size() > 0) {
            throw new RuntimeException("Cannot set text with element children");
        }
        Text text = CMLUtil.getFirstTextDescendant((Node)element);
        if (text == null) {
            text = new Text(s);
            element.appendChild((Node)text);
        } else {
            text.setValue(s);
        }
    }

    public static String getXMLContent(Element element) {
        List<Node> elements = CMLUtil.getQueryNodes((Node)element, "*");
        if (elements.size() > 0) {
            throw new RuntimeException("Cannot get text with element children");
        }
        return element.getValue();
    }

    public static String toXMLString(Element element) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            CMLUtil.debug(element, baos, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(baos.toByteArray());
    }

    public static CMLElement readElementFromResource(String filename) {
        CMLElement element = null;
        try {
            InputStream in = Util.getInputStreamFromResource((String)filename);
            element = (CMLElement)new CMLBuilder().build(in).getRootElement();
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException("parse/read exception in " + filename + "; " + e);
        }
        return element;
    }

    public static void BUG(String message) {
        Util.BUG((String)message);
    }

    public static List<String> getPrefixes(Element element, String attName) {
        ArrayList<String> prefixList = new ArrayList<String>();
        List<Node> refs = CMLUtil.getQueryNodes((Node)element, ".//@" + attName, CML_XPATH);
        for (Node node : refs) {
            Attribute attribute = (Attribute)node;
            String value = attribute.getValue();
            String prefix = CMLUtil.getPrefix(value);
            if (prefixList.contains(prefix)) continue;
            prefixList.add(prefix);
        }
        return prefixList;
    }

    public static List<CMLNamespace> getNamespaces(Element element, List<String> prefixes) {
        ArrayList<CMLNamespace> namespaceList = new ArrayList<CMLNamespace>();
        for (String prefix : prefixes) {
            String namespaceURI = element.getNamespaceURI(prefix);
            if (namespaceURI == null) {
                throw new RuntimeException("Missing namespace :" + prefix + ":");
            }
            CMLNamespace namespace = new CMLNamespace(prefix, namespaceURI);
            namespaceList.add(namespace);
        }
        return namespaceList;
    }

    public static List<List<Integer>> generateCombinationList(int max) {
        ArrayList<List<Integer>> combinationList = new ArrayList<List<Integer>>();
        int count = (int)Math.pow(2.0, max);
        for (int i = 2; i <= count; ++i) {
            int thisCount = i;
            ArrayList<Integer> intSet = new ArrayList<Integer>(max);
            for (int j = max; j >= 0; --j) {
                int test = thisCount;
                int minus = (int)Math.pow(2.0, j);
                if (test - minus <= 0) continue;
                thisCount -= minus;
                intSet.add(j);
            }
            combinationList.add(intSet);
        }
        combinationList.add(new ArrayList(0));
        return combinationList;
    }

    public static String makeId(String s) {
        String id = null;
        if (s != null) {
            id = s.toLowerCase();
            id = id.replace(" ", "_");
        }
        return id;
    }

    public static String makeCMLName(String name) {
        return "CML" + CMLUtil.capitalize(name);
    }

    public static String makeAbstractName(String name) {
        return "Abstract" + CMLUtil.capitalize(name);
    }

    public static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String equalsCanonically(String refNodeXML, Element testElement, boolean stripWhite) {
        Element refElement = null;
        try {
            refElement = new Builder().build((Reader)new StringReader(refNodeXML)).getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing failed: " + refNodeXML);
        }
        String message = CMLUtil.equalsCanonically(refElement, testElement, stripWhite, "/");
        LOG.trace((Object)("EQCAN " + message));
        return message;
    }

    public static String equalsCanonically(Element refElement, Element testElement, boolean stripWhite) {
        return CMLUtil.equalsCanonically(refElement, testElement, stripWhite, "./");
    }

    public static String equalsCanonically(Element refElement, Element testElement, boolean stripWhite, String xpath) {
        String message = null;
        if (refElement != testElement) {
            if (stripWhite) {
                refElement = new Element(refElement);
                CMLUtil.removeWhitespaceNodes(refElement);
                testElement = new Element(testElement);
                CMLUtil.removeWhitespaceNodes(testElement);
            }
            xpath = xpath + "*[local-name()='" + refElement.getLocalName() + "']/";
            message = CMLUtil.equalsCanonically(refElement, testElement, xpath);
        }
        return message;
    }

    private static String equalsCanonically(Element refElement, Element testElement, String xpath) {
        String message = CMLUtil.compareNamespacesCanonically(refElement, testElement, xpath);
        if (message != null) {
            return message;
        }
        String refName = refElement.getLocalName();
        String testName = testElement.getLocalName();
        if (message == null && !refName.equals(testName)) {
            message = "element names differ at " + xpath + ": " + refName + " != " + testName;
        }
        String refNamespace = refElement.getNamespaceURI();
        String testNamespace = testElement.getNamespaceURI();
        if (message == null && !refNamespace.equals(testNamespace)) {
            message = "element namespaces differ at " + xpath + ": " + refNamespace + " != " + testNamespace;
        }
        if (message == null) {
            message = CMLUtil.compareAttributesCanonically(refElement, testElement, xpath);
        }
        if (message == null) {
            message = CMLUtil.compareChildNodesCanonically(refElement, testElement, xpath);
        }
        return message;
    }

    public static String getCommonLeadingString(String s1, String s2) {
        int i;
        int l = Math.min(s1.length(), s2.length());
        for (i = 0; i < l && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return s1.substring(0, i);
    }

    public static String compareNamespacesCanonically(Element refNode, Element testNode, String xpath) {
        String message = null;
        List<String> refNamespaceURIList = CMLUtil.getNamespaceURIList(refNode);
        List<String> testNamespaceURIList = CMLUtil.getNamespaceURIList(testNode);
        if (refNamespaceURIList.size() != testNamespaceURIList.size()) {
            message = "unequal namespace count; ref " + refNamespaceURIList.size() + ";" + " testCount " + testNamespaceURIList.size();
        } else {
            for (String refNamespaceURI : refNamespaceURIList) {
                if (testNamespaceURIList.contains(refNamespaceURI)) continue;
                message = "Cannot find " + refNamespaceURI + " in test namespaces ";
                break;
            }
        }
        return message;
    }

    private static List<String> getNamespaceURIList(Element node) {
        ArrayList<String> namespaceURIList = new ArrayList<String>();
        for (int i = 0; i < node.getNamespaceDeclarationCount(); ++i) {
            String prefix = node.getNamespacePrefix(i);
            String refNamespaceURI = node.getNamespaceURI(prefix);
            namespaceURIList.add(refNamespaceURI);
        }
        return namespaceURIList;
    }

    public static String compareAttributesCanonically(Element refNode, Element testNode, String xpath) {
        int testCount;
        String message = null;
        int refCount = refNode.getAttributeCount();
        if (refCount != (testCount = testNode.getAttributeCount())) {
            message = "unequal attribute count at " + xpath + " (" + refCount + " != " + testCount + ")";
        }
        if (message == null) {
            for (int i = 0; i < refCount; ++i) {
                String testValue;
                Attribute testAttribute;
                Attribute attribute = refNode.getAttribute(i);
                String name = attribute.getLocalName();
                String namespace = attribute.getNamespaceURI();
                String value = attribute.getValue();
                Attribute attribute2 = testAttribute = namespace == null ? testNode.getAttribute(name) : testNode.getAttribute(name, namespace);
                if (testAttribute == null) {
                    message = "no attribute in test (" + xpath + ") for " + CMLUtil.printName(name, namespace);
                    break;
                }
                String refValue = CMLUtil.normalizeSpace(value);
                if (refValue.equals(testValue = CMLUtil.normalizeSpace(testAttribute.getValue()))) continue;
                message = "normalized attribute values for (" + xpath + "@" + CMLUtil.printName(name, namespace) + ") " + refValue + " != " + testValue;
                break;
            }
        }
        LOG.trace((Object)("ATT MS " + message));
        return message;
    }

    private static String printName(String name, String namespace) {
        return name + (namespace == null || namespace.equals("") ? "" : "[" + namespace + "]");
    }

    public static String normalizeSpace(String value) {
        return value.replaceAll("\\s+", " ").trim();
    }

    public static String compareChildNodesCanonically(Element refNode, Element testNode, String xpath) {
        int testCount;
        String message = null;
        int refCount = refNode.getChildCount();
        if (refCount != (testCount = testNode.getChildCount())) {
            message = "unequal child node count at " + xpath + " (" + refCount + " != " + testCount + ")";
        }
        if (message == null) {
            for (int i = 0; i < refCount; ++i) {
                Class<?> testClass;
                String xpathChild = xpath + "node()[position()=" + (i + 1) + "]";
                Node refChildNode = refNode.getChild(i);
                Node testChildNode = testNode.getChild(i);
                Class<?> refClass = refChildNode.getClass();
                if (!refClass.equals(testClass = testChildNode.getClass())) {
                    message = "child node classes differ at " + xpathChild + " " + refClass + "/" + testClass;
                    break;
                }
                if (refChildNode instanceof Element) {
                    message = CMLUtil.equalsCanonically((Element)refChildNode, (Element)testChildNode, xpathChild);
                    continue;
                }
                message = CMLUtil.compareNonElementNodesCanonically((Node)refNode, (Node)testNode, xpath);
                if (message != null) break;
            }
        }
        return message;
    }

    public static String compareNonElementNodesCanonically(Node refNode, Node testNode, String xpath) {
        String message = null;
        String refValue = refNode.getValue();
        String testValue = testNode.getValue();
        if (refNode instanceof Comment) {
            if (!refValue.equals(testValue)) {
                message = "comments at (" + xpath + ") differ: " + refValue + " != " + testValue;
            }
        } else if (refNode instanceof Text) {
            if (!refValue.equals(testValue)) {
                message = "text contents at (" + xpath + ") differ: [" + refValue + "] != [" + testValue + "]";
            }
        } else if (refNode instanceof ProcessingInstruction) {
            String testTarget;
            String refTarget = ((ProcessingInstruction)refNode).getTarget();
            if (!refTarget.equals(testTarget = ((ProcessingInstruction)testNode).getTarget())) {
                message = "PI targets at (" + xpath + ") differ: " + refTarget + " != " + testTarget;
            }
        } else {
            LOG.warn((Object)"Unknown XML element in comparison");
        }
        return message;
    }

    public static void stripTrailingWhitespaceinTexts(Element element) {
        Nodes texts = element.query("//text()");
        for (int i = 0; i < texts.size(); ++i) {
            Text text = (Text)texts.get(i);
            String value = text.getValue();
            value = Util.rightTrim((String)value);
            text.setValue(value);
        }
    }

    public static Element getSingleElement(Element element, String xpath) {
        Nodes nodes = element.query(xpath);
        return nodes.size() == 1 ? (Element)nodes.get(0) : null;
    }

    public static void detach(Element element) {
        ParentNode parent;
        ParentNode parentNode = parent = element == null ? null : element.getParent();
        if (parent != null) {
            if (parent instanceof Document) {
                parent.replaceChild((Node)element, (Node)new Element(DUMMY));
            } else {
                element.detach();
            }
        }
    }

    public static Document ensureDocument(Element rootElement) {
        Document doc = null;
        if (rootElement != null && (doc = rootElement.getDocument()) == null) {
            doc = new Document(rootElement);
        }
        return doc;
    }

    public static Document parseQuietlyToDocument(InputStream is) {
        Document document = null;
        try {
            document = new Builder().build(is);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot parse/read stream: ", e);
        }
        return document;
    }

    public static Document parseQuietlyToCMLDocument(InputStream is) {
        Document document = null;
        try {
            document = new CMLBuilder().build(is);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot parse/read stream: ", e);
        }
        return document;
    }

    public static Document parseResourceQuietlyToDocument(String resource) {
        Document document = null;
        try {
            document = new Builder().build(Util.getInputStreamFromResource((String)resource));
        }
        catch (Exception e) {
            throw new RuntimeException("cannot parse/read resource: " + resource, e);
        }
        return document;
    }

    public static Document parseQuietlyToDocument(File xmlFile) {
        Document document = null;
        try {
            document = new Builder().build(xmlFile);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot parse/read file: " + xmlFile.getAbsolutePath(), e);
        }
        return document;
    }

    public static CMLElement parseQuietlyIntoCML(String s) {
        ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
        return CMLUtil.parseQuietlyIntoCML(bais);
    }

    public static CMLElement parseQuietlyIntoCML(File xmlFile) {
        CMLElement rootElement = null;
        try {
            rootElement = (CMLElement)new CMLBuilder().build(xmlFile).getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot parse/read file: " + xmlFile.getAbsolutePath(), e);
        }
        return rootElement;
    }

    public static CMLElement parseQuietlyIntoCML(InputStream inputStream) {
        CMLElement rootElement = null;
        try {
            rootElement = (CMLElement)new CMLBuilder().build(inputStream).getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot parse/read inputStream ", e);
        }
        return rootElement;
    }

    public static Document parseQuietlyIntoCMLDocument(File xmlFile) {
        Document document = CMLUtil.ensureDocument(CMLUtil.parseQuietlyIntoCML(xmlFile));
        return document;
    }

    public static List<CMLMolecule> convertNodesToMoleculeList(Nodes moleculeNodes) {
        ArrayList<CMLMolecule> moleculeList = new ArrayList<CMLMolecule>();
        for (int i = 0; i < moleculeNodes.size(); ++i) {
            moleculeList.add((CMLMolecule)moleculeNodes.get(i));
        }
        return moleculeList;
    }

    public static List<CMLMolecule> extractTopLevelMolecules(Node node) {
        String xpath = "//*[not(local-name()='molecule')]/*[local-name()='molecule'] | self::*[local-name()='molecule']";
        return CMLUtil.convertNodesToMoleculeList(node.query(xpath));
    }

    public static void removeNonCMLAttributes(CMLElement element) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            Attribute attribute = element.getAttribute(i);
            String namespaceURI = attribute.getNamespaceURI();
            if (namespaceURI == null || namespaceURI.equals("") || namespaceURI.equals("http://www.xml-cml.org/schema")) continue;
            attributes.add(attribute);
        }
        for (Attribute attribute : attributes) {
            attribute.detach();
        }
        List<CMLElement> childElementList = element.getChildCMLElements();
        for (CMLElement childElement : childElementList) {
            CMLUtil.removeNonCMLAttributes(childElement);
        }
    }

    public static Document stripDTDAndOtherProblematicXMLHeadings(String s) throws IOException {
        Document document;
        if (s == null || s.length() == 0) {
            throw new RuntimeException("zero length document");
        }
        int idx = s.indexOf(DTD);
        String baosS = s;
        if (idx != -1) {
            int ld = idx + DTD.length() + 1;
            if (ld < 0) {
                throw new RuntimeException("BUG in stripping DTD");
            }
            try {
                baosS = s.substring(ld);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot parse string: (" + s.length() + "/" + ld + "/" + idx + ") " + s.substring(0, Math.min(500, s.length())), e);
            }
        }
        baosS = baosS.replace(" xmlns=\"http://www.w3.org/1999/xhtml\"", "");
        baosS = baosS.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(baosS.getBytes());
            document = new Builder().build((InputStream)bais);
        }
        catch (Exception e) {
            System.out.println("trying to parse:" + baosS + ":");
            throw new RuntimeException("BUG: DTD stripper should have created valid XML: " + e);
        }
        return document;
    }

    public static void debugPreserveWhitespace(Element element) {
        try {
            CMLUtil.debug(element, System.out, 0);
        }
        catch (Exception e) {
            throw new RuntimeException("BUG", e);
        }
    }

    public static Element normalizeWhitespaceInTextNodes(Element element) {
        Nodes texts = element.query(".//text()");
        for (int i = 0; i < texts.size(); ++i) {
            Text text = (Text)texts.get(i);
            text.setValue(CMLUtil.normalizeSpace(text.getValue()));
        }
        return element;
    }
}

