/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractSpectatorList;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLFormula;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLReaction;
import org.xmlcml.cml.element.CMLSpectator;
import org.xmlcml.cml.element.ReactionComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLSpectatorList
extends AbstractSpectatorList
implements ReactionComponent {
    public static final String NS = "cml:spectatorList";

    public CMLSpectatorList() {
    }

    public CMLSpectatorList(CMLSpectatorList old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLSpectatorList(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLSpectatorList();
    }

    public List<CMLMolecule> getSpectatorMolecules(String productReactant) {
        Elements spectators = this.getChildCMLElements("spectator");
        int serial = productReactant.equals("reactant") ? 0 : 1;
        ArrayList<CMLMolecule> moleculeList = new ArrayList<CMLMolecule>();
        for (int i = 0; i < spectators.size(); ++i) {
            CMLMolecule molecule = (CMLMolecule)((CMLSpectator)spectators.get(i)).getChildCMLElement("molecule", serial);
            if (molecule == null) continue;
            moleculeList.add(molecule);
        }
        return moleculeList;
    }

    @Override
    public List<CMLAtom> getAtoms() {
        return CMLReaction.getAtoms(this);
    }

    @Override
    public List<CMLBond> getBonds() {
        return CMLReaction.getBonds(this);
    }

    @Override
    public List<CMLFormula> getFormulas() {
        return CMLReaction.getFormulas(this);
    }

    @Override
    public List<CMLMolecule> getMolecules() {
        return CMLReaction.getMolecules(this);
    }

    public List<CMLMolecule> getMolecules(ReactionComponent.Type productReactant) {
        CMLElements<CMLSpectator> spectators = this.getSpectatorElements();
        int serial = productReactant.equals((Object)ReactionComponent.Type.REACTANT) ? 0 : 1;
        ArrayList<CMLMolecule> moleculeList = new ArrayList<CMLMolecule>();
        for (CMLSpectator spectator : spectators) {
            CMLMolecule molecule = spectator.getMoleculeElements().get(serial);
            if (molecule == null) continue;
            moleculeList.add(molecule);
        }
        return moleculeList;
    }

    public List<ReactionComponent> getReactionComponentDescendants() {
        return CMLReaction.getReactionComponentDescendants(this, true);
    }

    public List<ReactionComponent> getReactionComponentChildren() {
        return CMLReaction.getReactionComponentDescendants(this, false);
    }
}

