/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public final class HighlightGenerator
implements IGenerator<IAtomContainer> {
    private final HighlightRadius highlightRadius = new HighlightRadius();
    private final HighlightPalette highlightPalette = new HighlightPalette();
    public static final String ID_MAP = "cdk.highlight.id";
    private static final Palette DEFAULT_PALETTE = HighlightGenerator.createAutoGenPalette(true);

    @Override
    public IRenderingElement generate(IAtomContainer container, RendererModel model) {
        Shape shape;
        Area area;
        Integer id;
        Map highlight = (Map)container.getProperty(ID_MAP);
        if (highlight == null) {
            return null;
        }
        Palette palette = (Palette)model.getParameter(HighlightPalette.class).getValue();
        double radius = (Double)model.getParameter(HighlightRadius.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        HashMap<Integer, Area> shapes = new HashMap<Integer, Area>();
        for (IAtom atom : container.atoms()) {
            id = (Integer)highlight.get(atom);
            if (id == null) continue;
            area = (Area)shapes.get(id);
            shape = HighlightGenerator.createAtomHighlight(atom, radius);
            if (area == null) {
                shapes.put(id, new Area(shape));
                continue;
            }
            area.add(new Area(shape));
        }
        for (IBond bond : container.bonds()) {
            id = (Integer)highlight.get(bond);
            if (id == null) continue;
            area = (Area)shapes.get(id);
            shape = HighlightGenerator.createBondHighlight(bond, radius);
            if (area == null) {
                area = new Area(shape);
                shapes.put(id, area);
            } else {
                area.add(new Area(shape));
            }
            IAtom a1 = bond.getAtom(0);
            IAtom a2 = bond.getAtom(1);
            Integer a1Id = (Integer)highlight.get(a1);
            Integer a2Id = (Integer)highlight.get(a2);
            if (a1Id != null && !a1Id.equals(id)) {
                area.subtract((Area)shapes.get(a1Id));
            }
            if (a2Id == null || a2Id.equals(id)) continue;
            area.subtract((Area)shapes.get(a2Id));
        }
        ElementGroup group = new ElementGroup();
        for (Map.Entry e : shapes.entrySet()) {
            group.add(GeneralPath.shapeOf((Shape)e.getValue(), palette.color((Integer)e.getKey())));
        }
        return group;
    }

    private static Shape createAtomHighlight(IAtom atom, double radius) {
        double x = atom.getPoint2d().x;
        double y = atom.getPoint2d().y;
        return new RoundRectangle2D.Double(x - radius, y - radius, 2.0 * radius, 2.0 * radius, 2.0 * radius, 2.0 * radius);
    }

    private static Shape createBondHighlight(IBond bond, double radius) {
        double x1 = bond.getAtom((int)0).getPoint2d().x;
        double x2 = bond.getAtom((int)1).getPoint2d().x;
        double y1 = bond.getAtom((int)0).getPoint2d().y;
        double y2 = bond.getAtom((int)1).getPoint2d().y;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double mag = Math.sqrt(dx * dx + dy * dy);
        double r2 = radius / 2.0;
        RoundRectangle2D.Double s = new RoundRectangle2D.Double(x1 - r2, y1 - r2, mag + radius, radius, radius, radius);
        double theta = Math.atan2(dy /= mag, dx /= mag);
        return AffineTransform.getRotateInstance(theta, x1, y1).createTransformedShape(s);
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.highlightRadius, this.highlightPalette);
    }

    public static Palette createPalette(Color[] colors) {
        return new FixedPalette(colors);
    }

    public static Palette createPalette(Color color, Color ... colors) {
        Color[] cs = new Color[colors.length + 1];
        cs[0] = color;
        System.arraycopy(colors, 0, cs, 1, colors.length);
        return new FixedPalette(cs);
    }

    public static Palette createAutoPalette(float saturation, float brightness, int alpha) {
        return new AutoGenerated(5, saturation, brightness, alpha);
    }

    public static Palette createAutoGenPalette(float saturation, float brightness, boolean transparent) {
        return new AutoGenerated(5, saturation, brightness, transparent ? 200 : 255);
    }

    public static Palette createAutoGenPalette(boolean transparent) {
        return new AutoGenerated(5, transparent ? 200 : 255);
    }

    public static class HighlightPalette
    extends AbstractGeneratorParameter<Palette> {
        @Override
        public Palette getDefault() {
            return DEFAULT_PALETTE;
        }
    }

    public static class HighlightRadius
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 10.0;
        }
    }

    private static final class AutoGenerated
    implements Palette {
        private static final float PHI = 0.618034f;
        private static final int offset = 14;
        private Color[] colors;
        private final int alpha;
        private final float saturation;
        private final float brightness;

        public AutoGenerated(int n, int alpha) {
            this(n, 0.45f, 0.95f, alpha);
        }

        public AutoGenerated(int n, float saturation, float brightness, int alpha) {
            this.colors = new Color[n];
            this.alpha = alpha;
            this.saturation = saturation;
            this.brightness = brightness;
            this.fill(this.colors, 0, n - 1);
        }

        private void fill(Color[] colors, int from, int to) {
            if (this.alpha < 255) {
                for (int i = from; i <= to; ++i) {
                    Color c = Color.getHSBColor((float)(14 + i) * 0.618034f, this.saturation, this.brightness);
                    colors[i] = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
                }
            } else {
                for (int i = from; i <= to; ++i) {
                    colors[i] = Color.getHSBColor((float)(14 + i) * 0.618034f, this.saturation, this.brightness);
                }
            }
        }

        @Override
        public Color color(int id) {
            if (id < 0) {
                throw new IllegalArgumentException("id should be positive");
            }
            if (id >= this.colors.length) {
                int org = this.colors.length;
                this.colors = Arrays.copyOf(this.colors, id * 2);
                this.fill(this.colors, org, this.colors.length - 1);
            }
            return this.colors[id];
        }
    }

    private static final class FixedPalette
    implements Palette {
        private final Color[] colors;

        public FixedPalette(Color[] colors) {
            this.colors = Arrays.copyOf(colors, colors.length);
        }

        @Override
        public Color color(int id) {
            if (id < 0) {
                throw new IllegalArgumentException("id should be positive");
            }
            if (id >= this.colors.length) {
                throw new IllegalArgumentException("no color has been provided for id=" + id);
            }
            return this.colors[id];
        }
    }

    public static interface Palette {
        public Color color(int var1);
    }
}

