/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.layout.AtomPlacer;
import org.openscience.cdk.layout.CorrectGeometricConfiguration;
import org.openscience.cdk.layout.HydrogenPlacer;
import org.openscience.cdk.layout.NonplanarBonds;
import org.openscience.cdk.layout.RingPlacer;
import org.openscience.cdk.layout.TemplateHandler;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class StructureDiagramGenerator {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(StructureDiagramGenerator.class);
    private static TemplateHandler DEFAULT_TEMPLATE_HANDLER = null;
    private IAtomContainer molecule;
    private IRingSet sssr;
    private double bondLength = 1.5;
    private Vector2d firstBondVector;
    private RingPlacer ringPlacer = new RingPlacer();
    private AtomPlacer atomPlacer = new AtomPlacer();
    private List ringSystems = null;
    private final String disconnectedMessage = "Molecule not connected. Use ConnectivityChecker.partitionIntoMolecules() and do the layout for every single component.";
    private TemplateHandler templateHandler = null;
    private boolean useTemplates = true;
    private IAtomContainerSet mappedSubstructures;

    public StructureDiagramGenerator() {
    }

    public StructureDiagramGenerator(IAtomContainer molecule) {
        this();
        this.setMolecule(molecule, false);
        this.templateHandler = new TemplateHandler(molecule.getBuilder());
    }

    public void setMolecule(IAtomContainer mol, boolean clone) {
        this.templateHandler = new TemplateHandler(mol.getBuilder());
        IAtom atom = null;
        if (clone) {
            try {
                this.molecule = mol.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error("Should clone, but exception occured: ", e.getMessage());
                this.logger.debug(e);
            }
        } else {
            this.molecule = mol;
        }
        for (int f = 0; f < this.molecule.getAtomCount(); ++f) {
            atom = this.molecule.getAtom(f);
            atom.setPoint2d(null);
            atom.setFlag(1, false);
            atom.setFlag(16, false);
            atom.setFlag(2, false);
            atom.setFlag(8, false);
        }
        this.atomPlacer.setMolecule(this.molecule);
        this.ringPlacer.setMolecule(this.molecule);
        this.ringPlacer.setAtomPlacer(this.atomPlacer);
    }

    public void setUseTemplates(boolean useTemplates) {
        this.useTemplates = useTemplates;
    }

    public boolean getUseTemplates() {
        return this.useTemplates;
    }

    public void setTemplateHandler(TemplateHandler templateHandler) {
        this.templateHandler = templateHandler;
    }

    public TemplateHandler getTemplateHandler() {
        if (this.templateHandler == null) {
            return DEFAULT_TEMPLATE_HANDLER;
        }
        return this.templateHandler;
    }

    public void setMolecule(IAtomContainer molecule) {
        this.setMolecule(molecule, true);
    }

    public IAtomContainer getMolecule() {
        return this.molecule;
    }

    public void generateExperimentalCoordinates() throws CDKException {
        this.generateExperimentalCoordinates(new Vector2d(0.0, 1.0));
    }

    public void generateExperimentalCoordinates(Vector2d firstBondVector) throws CDKException {
        IAtomContainer original = this.molecule;
        IAtomContainer shallowCopy = this.molecule.getBuilder().newInstance(IAtomContainer.class, this.molecule);
        for (IAtom curAtom : shallowCopy.atoms()) {
            if (!curAtom.getSymbol().equals("H") || shallowCopy.getConnectedBondsCount(curAtom) >= 2) continue;
            shallowCopy.removeAtomAndConnectedElectronContainers(curAtom);
            curAtom.setPoint2d(null);
        }
        this.molecule = shallowCopy;
        this.generateCoordinates(firstBondVector);
        double bondLength = GeometryTools.getBondLengthAverage(this.molecule);
        HydrogenPlacer hPlacer = new HydrogenPlacer();
        this.molecule = original;
        hPlacer.placeHydrogens2D(this.molecule, bondLength);
    }

    public void generateCoordinates(Vector2d firstBondVector) throws CDKException {
        int expectedRingCount;
        int safetyCounter = 0;
        this.logger.debug("Entry point of generateCoordinates()");
        this.logger.debug("We have a molecules with " + this.molecule.getAtomCount() + " atoms.");
        if (this.molecule.getAtomCount() == 1) {
            this.molecule.getAtom(0).setPoint2d(new Point2d(0.0, 0.0));
            return;
        }
        if (!ConnectivityChecker.isConnected(this.molecule)) {
            this.logger.debug("Molecule is not connected. Throwing exception.");
            throw new CDKException("Molecule not connected. Use ConnectivityChecker.partitionIntoMolecules() and do the layout for every single component.");
        }
        this.logger.debug("Molecule is connected.");
        int nrOfEdges = this.molecule.getBondCount();
        this.firstBondVector = firstBondVector;
        boolean templateMapped = false;
        if (this.useTemplates && System.getProperty("java.version").indexOf("1.3.") == -1) {
            this.logger.debug("Initializing TemplateHandler");
            this.logger.debug("TemplateHander initialized");
            this.logger.debug("Now starting Template Detection in Molecule...");
            this.mappedSubstructures = this.getTemplateHandler().getMappedSubstructures(this.molecule);
            templateMapped = this.mappedSubstructures.getAtomContainerCount() > 0;
            this.logger.debug("Template Detection finished");
            this.logger.debug("Number of found templates: " + this.mappedSubstructures.getAtomContainerCount());
        }
        if ((expectedRingCount = nrOfEdges - this.molecule.getAtomCount() + 1) > 0) {
            this.logger.debug("*** Start of handling rings. ***");
            this.sssr = Cycles.sssr(this.molecule).toRingSet();
            if (this.sssr.getAtomContainerCount() < 1) {
                return;
            }
            AtomContainerSetManipulator.sort(this.sssr);
            this.markRingAtoms(this.sssr);
            this.ringPlacer.setMolecule(this.molecule);
            this.ringPlacer.checkAndMarkPlaced(this.sssr);
            this.ringSystems = RingPartitioner.partitionRings(this.sssr);
            int largest = 0;
            int largestSize = ((IRingSet)this.ringSystems.get(0)).getAtomContainerCount();
            this.logger.debug("We have " + this.ringSystems.size() + " ring system(s).");
            for (int f = 0; f < this.ringSystems.size(); ++f) {
                this.logger.debug("RingSet " + f + " has size " + ((IRingSet)this.ringSystems.get(f)).getAtomContainerCount());
                if (((IRingSet)this.ringSystems.get(f)).getAtomContainerCount() <= largestSize) continue;
                largestSize = ((IRingSet)this.ringSystems.get(f)).getAtomContainerCount();
                largest = f;
            }
            this.logger.debug("Largest RingSystem is at RingSet collection's position " + largest);
            this.logger.debug("Size of Largest RingSystem: " + largestSize);
            this.layoutRingSet(firstBondVector, (IRingSet)this.ringSystems.get(largest));
            this.logger.debug("First RingSet placed");
            this.ringPlacer.placeRingSubstituents((IRingSet)this.ringSystems.get(largest), this.bondLength);
        } else {
            this.logger.debug("*** Start of handling purely aliphatic molecules. ***");
            this.logger.debug("Searching initialLongestChain for this purely aliphatic molecule");
            IAtomContainer longestChain = AtomPlacer.getInitialLongestChain(this.molecule);
            this.logger.debug("Found linear chain of length " + longestChain.getAtomCount());
            this.logger.debug("Setting coordinated of first atom to 0,0");
            longestChain.getAtom(0).setPoint2d(new Point2d(0.0, 0.0));
            longestChain.getAtom(0).setFlag(1, true);
            double angle = Math.toRadians(-30.0);
            this.logger.debug("Attempting to place the first bond such that the whole chain will be horizontally alligned on the x axis");
            if (firstBondVector != null) {
                this.atomPlacer.placeLinearChain(longestChain, firstBondVector, this.bondLength);
            } else {
                this.atomPlacer.placeLinearChain(longestChain, new Vector2d(Math.cos(angle), Math.sin(angle)), this.bondLength);
            }
            this.logger.debug("Placed longest aliphatic chain");
        }
        do {
            this.logger.debug("*** Start of handling the rest of the molecule. ***");
            this.handleAliphatics();
            this.layoutNextRingSystem();
        } while (!AtomPlacer.allPlaced(this.molecule) && ++safetyCounter <= this.molecule.getAtomCount());
        this.fixRest();
        CorrectGeometricConfiguration.correct(this.molecule);
        NonplanarBonds.assign(this.molecule);
    }

    public void generateCoordinates() throws CDKException {
        this.generateCoordinates(new Vector2d(0.0, 1.0));
    }

    private void layoutRingSet(Vector2d firstBondVector, IRingSet rs) throws CDKException {
        this.logger.debug("Start of layoutRingSet");
        if (this.useTemplates && this.mappedSubstructures.getAtomContainerCount() > 0 && System.getProperty("java.version").indexOf("1.3.") == -1) {
            for (IAtomContainer substructure : this.mappedSubstructures.atomContainers()) {
                boolean substructureMapped = false;
                Iterator<IAtomContainer> ringSetIterator = rs.atomContainers().iterator();
                while (ringSetIterator.hasNext() && !substructureMapped) {
                    IRing ring = (IRing)ringSetIterator.next();
                    Iterator<IAtom> atomIterator = ring.atoms().iterator();
                    while (atomIterator.hasNext() && !substructureMapped) {
                        IAtom atom = atomIterator.next();
                        if (!substructure.contains(atom)) continue;
                        substructureMapped = true;
                    }
                }
                if (!substructureMapped) continue;
                boolean mapped = this.getTemplateHandler().mapTemplateExact(substructure);
                if (!mapped) {
                    this.logger.warn("A supposedly matched substructure failed to match.");
                    continue;
                }
                for (IAtom atom : substructure.atoms()) {
                    atom.setFlag(1, true);
                }
                this.ringPlacer.checkAndMarkPlaced(rs);
            }
        }
        IRing ring = RingSetManipulator.getMostComplexRing(rs);
        int i = 0;
        if (!ring.getFlag(1)) {
            IAtomContainer sharedAtoms = this.placeFirstBond(ring.getBond(i), firstBondVector);
            Vector2d ringCenterVector = this.ringPlacer.getRingCenterOfFirstRing(ring, firstBondVector, this.bondLength);
            this.ringPlacer.placeRing(ring, sharedAtoms, GeometryTools.get2DCenter(sharedAtoms), ringCenterVector, this.bondLength);
            ring.setFlag(1, true);
        }
        int thisRing = 0;
        do {
            if (ring.getFlag(1)) {
                this.ringPlacer.placeConnectedRings(rs, ring, RingPlacer.FUSED, this.bondLength);
                this.ringPlacer.placeConnectedRings(rs, ring, RingPlacer.BRIDGED, this.bondLength);
                this.ringPlacer.placeConnectedRings(rs, ring, RingPlacer.SPIRO, this.bondLength);
            }
            if (++thisRing == rs.getAtomContainerCount()) {
                thisRing = 0;
            }
            ring = (IRing)rs.getAtomContainer(thisRing);
        } while (!this.allPlaced(rs));
        this.logger.debug("End of layoutRingSet");
    }

    private void handleAliphatics() throws CDKException {
        boolean done;
        this.logger.debug("Start of handleAliphatics");
        int safetyCounter = 0;
        IAtomContainer unplacedAtoms = null;
        IAtomContainer placedAtoms = null;
        IAtomContainer longestUnplacedChain = null;
        IAtom atom = null;
        Vector2d direction = null;
        Vector2d startVector = null;
        do {
            ++safetyCounter;
            done = false;
            atom = this.getNextAtomWithAliphaticUnplacedNeigbors();
            if (atom != null) {
                unplacedAtoms = this.getUnplacedAtoms(atom);
                placedAtoms = this.getPlacedAtoms(atom);
                longestUnplacedChain = AtomPlacer.getLongestUnplacedChain(this.molecule, atom);
                this.logger.debug("---start of longest unplaced chain---");
                try {
                    this.logger.debug("Start at atom no. " + (this.molecule.getAtomNumber(atom) + 1));
                    this.logger.debug(AtomPlacer.listNumbers(this.molecule, longestUnplacedChain));
                }
                catch (Exception exc) {
                    this.logger.debug(exc);
                }
                this.logger.debug("---end of longest unplaced chain---");
                if (longestUnplacedChain.getAtomCount() > 1) {
                    if (placedAtoms.getAtomCount() > 1) {
                        this.logger.debug("More than one atoms placed already");
                        this.logger.debug("trying to place neighbors of atom " + (this.molecule.getAtomNumber(atom) + 1));
                        this.atomPlacer.distributePartners(atom, placedAtoms, GeometryTools.get2DCenter(placedAtoms), unplacedAtoms, this.bondLength);
                        direction = new Vector2d(longestUnplacedChain.getAtom(1).getPoint2d());
                        startVector = new Vector2d(atom.getPoint2d());
                        direction.sub(startVector);
                        this.logger.debug("Done placing neighbors of atom " + (this.molecule.getAtomNumber(atom) + 1));
                    } else {
                        this.logger.debug("Less than or equal one atoms placed already");
                        this.logger.debug("Trying to get next bond vector.");
                        direction = this.atomPlacer.getNextBondVector(atom, placedAtoms.getAtom(0), GeometryTools.get2DCenter(this.molecule), true);
                    }
                    for (int f = 1; f < longestUnplacedChain.getAtomCount(); ++f) {
                        longestUnplacedChain.getAtom(f).setFlag(1, false);
                    }
                    this.atomPlacer.placeLinearChain(longestUnplacedChain, direction, this.bondLength);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        } while (!done && safetyCounter <= this.molecule.getAtomCount());
        this.logger.debug("End of handleAliphatics");
    }

    private void layoutNextRingSystem() throws CDKException {
        this.logger.debug("Start of layoutNextRingSystem()");
        this.resetUnplacedRings();
        IAtomContainer tempAc = AtomPlacer.getPlacedAtoms(this.molecule);
        this.logger.debug("Finding attachment bond to already placed part...");
        IBond nextRingAttachmentBond = this.getNextBondWithUnplacedRingAtom();
        if (nextRingAttachmentBond != null) {
            this.logger.debug("...bond found.");
            IAtom ringAttachmentAtom = this.getRingAtom(nextRingAttachmentBond);
            IAtom chainAttachmentAtom = this.getOtherBondAtom(ringAttachmentAtom, nextRingAttachmentBond);
            IRingSet nextRingSystem = this.getRingSystemOfAtom(this.ringSystems, ringAttachmentAtom);
            IAtomContainer ringSystem = tempAc.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            Iterator<IAtomContainer> containers = RingSetManipulator.getAllAtomContainers(nextRingSystem).iterator();
            while (containers.hasNext()) {
                ringSystem.add(containers.next());
            }
            Point2d oldRingAttachmentAtomPoint = ringAttachmentAtom.getPoint2d();
            Point2d oldChainAttachmentAtomPoint = chainAttachmentAtom.getPoint2d();
            this.layoutRingSet(this.firstBondVector, nextRingSystem);
            AtomPlacer.markNotPlaced(tempAc);
            IAtomContainer placedRingSubstituents = this.ringPlacer.placeRingSubstituents(nextRingSystem, this.bondLength);
            ringSystem.add(placedRingSubstituents);
            AtomPlacer.markPlaced(tempAc);
            this.logger.debug("Computing translation/rotation of new ringset to fit old attachment bond orientation...");
            Point2d oldPoint2 = oldRingAttachmentAtomPoint;
            Point2d oldPoint1 = oldChainAttachmentAtomPoint;
            Point2d newPoint2 = ringAttachmentAtom.getPoint2d();
            Point2d newPoint1 = chainAttachmentAtom.getPoint2d();
            this.logger.debug("oldPoint1: " + oldPoint1);
            this.logger.debug("oldPoint2: " + oldPoint2);
            this.logger.debug("newPoint1: " + newPoint1);
            this.logger.debug("newPoint2: " + newPoint2);
            double oldAngle = GeometryTools.getAngle(oldPoint2.x - oldPoint1.x, oldPoint2.y - oldPoint1.y);
            double newAngle = GeometryTools.getAngle(newPoint2.x - newPoint1.x, newPoint2.y - newPoint1.y);
            double angleDiff = oldAngle - newAngle;
            this.logger.debug("oldAngle: " + oldAngle + ", newAngle: " + newAngle + "; diff = " + angleDiff);
            Vector2d translationVector = new Vector2d(oldPoint1);
            translationVector.sub(new Vector2d(newPoint1));
            GeometryTools.translate2D(ringSystem, translationVector);
            GeometryTools.rotate(ringSystem, oldPoint1, angleDiff);
            this.logger.debug("...done translating/rotating new ringset to fit old attachment bond orientation.");
        } else {
            this.logger.debug("...no bond found");
        }
        this.logger.debug("End of layoutNextRingSystem()");
    }

    private IAtomContainer getUnplacedAtoms(IAtom atom) {
        IAtomContainer unplacedAtoms = atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        List<IBond> bonds = this.molecule.getConnectedBondsList(atom);
        for (int f = 0; f < bonds.size(); ++f) {
            IAtom connectedAtom = bonds.get(f).getConnectedAtom(atom);
            if (connectedAtom.getFlag(1)) continue;
            unplacedAtoms.addAtom(connectedAtom);
        }
        return unplacedAtoms;
    }

    private IAtomContainer getPlacedAtoms(IAtom atom) {
        IAtomContainer placedAtoms = atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        List<IBond> bonds = this.molecule.getConnectedBondsList(atom);
        for (int f = 0; f < bonds.size(); ++f) {
            IAtom connectedAtom = bonds.get(f).getConnectedAtom(atom);
            if (!connectedAtom.getFlag(1)) continue;
            placedAtoms.addAtom(connectedAtom);
        }
        return placedAtoms;
    }

    private IAtom getNextAtomWithAliphaticUnplacedNeigbors() {
        for (int f = 0; f < this.molecule.getBondCount(); ++f) {
            IBond bond = this.molecule.getBond(f);
            if (bond.getAtom(1).getFlag(1) && !bond.getAtom(0).getFlag(1)) {
                return bond.getAtom(1);
            }
            if (!bond.getAtom(0).getFlag(1) || bond.getAtom(1).getFlag(1)) continue;
            return bond.getAtom(0);
        }
        return null;
    }

    private IBond getNextBondWithUnplacedRingAtom() {
        for (IBond bond : this.molecule.bonds()) {
            if (bond.getAtom(0).getPoint2d() == null || bond.getAtom(1).getPoint2d() == null) continue;
            if (bond.getAtom(1).getFlag(1) && !bond.getAtom(0).getFlag(1) && bond.getAtom(0).getFlag(2)) {
                return bond;
            }
            if (!bond.getAtom(0).getFlag(1) || bond.getAtom(1).getFlag(1) || !bond.getAtom(1).getFlag(2)) continue;
            return bond;
        }
        return null;
    }

    private IAtomContainer placeFirstBond(IBond bond, Vector2d bondVector) {
        IAtomContainer sharedAtoms = null;
        try {
            bondVector.normalize();
            this.logger.debug("placeFirstBondOfFirstRing->bondVector.length():" + bondVector.length());
            bondVector.scale(this.bondLength);
            this.logger.debug("placeFirstBondOfFirstRing->bondVector.length() after scaling:" + bondVector.length());
            Point2d point = new Point2d(0.0, 0.0);
            IAtom atom = bond.getAtom(0);
            this.logger.debug("Atom 1 of first Bond: " + (this.molecule.getAtomNumber(atom) + 1));
            atom.setPoint2d(point);
            atom.setFlag(1, true);
            point = new Point2d(0.0, 0.0);
            atom = bond.getAtom(1);
            this.logger.debug("Atom 2 of first Bond: " + (this.molecule.getAtomNumber(atom) + 1));
            point.add(bondVector);
            atom.setPoint2d(point);
            atom.setFlag(1, true);
            sharedAtoms = atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            sharedAtoms.addBond(bond);
            sharedAtoms.addAtom(bond.getAtom(0));
            sharedAtoms.addAtom(bond.getAtom(1));
        }
        catch (Exception exc) {
            this.logger.debug(exc);
        }
        return sharedAtoms;
    }

    private void fixRest() {
        IAtom atom = null;
        for (int f = 0; f < this.molecule.getAtomCount(); ++f) {
            atom = this.molecule.getAtom(f);
            if (atom.getPoint2d() != null) continue;
            atom.setPoint2d(new Point2d(0.0, 0.0));
        }
    }

    private IAtomContainer fixMol(IAtomContainer molecule) {
        IAtom atom = null;
        for (int f = 0; f < molecule.getAtomCount(); ++f) {
            atom = molecule.getAtom(f);
            if (atom.getPoint2d() != null) continue;
            atom.setPoint2d(new Point2d(0.0, 0.0));
        }
        return molecule;
    }

    private boolean allPlaced(IRingSet rings) {
        for (int f = 0; f < rings.getAtomContainerCount(); ++f) {
            if (((IRing)rings.getAtomContainer(f)).getFlag(1)) continue;
            this.logger.debug("allPlaced->Ring " + f + " not placed");
            return false;
        }
        return true;
    }

    private void markRingAtoms(IRingSet rings) {
        IRing ring = null;
        for (int i = 0; i < rings.getAtomContainerCount(); ++i) {
            ring = (IRing)rings.getAtomContainer(i);
            for (int j = 0; j < ring.getAtomCount(); ++j) {
                ring.getAtom(j).setFlag(2, true);
            }
        }
    }

    private IAtom getRingAtom(IBond bond) {
        if (bond.getAtom(0).getFlag(2) && !bond.getAtom(0).getFlag(1)) {
            return bond.getAtom(0);
        }
        if (bond.getAtom(1).getFlag(2) && !bond.getAtom(1).getFlag(1)) {
            return bond.getAtom(1);
        }
        return null;
    }

    private IRingSet getRingSystemOfAtom(List ringSystems, IAtom ringAtom) {
        IRingSet ringSet = null;
        for (int f = 0; f < ringSystems.size(); ++f) {
            ringSet = (IRingSet)ringSystems.get(f);
            if (!ringSet.contains(ringAtom)) continue;
            return ringSet;
        }
        return null;
    }

    private void resetUnplacedRings() {
        IRing ring = null;
        if (this.sssr == null) {
            return;
        }
        int unplacedCounter = 0;
        for (int f = 0; f < this.sssr.getAtomContainerCount(); ++f) {
            ring = (IRing)this.sssr.getAtomContainer(f);
            if (ring.getFlag(1)) continue;
            this.logger.debug("Ring with " + ring.getAtomCount() + " atoms is not placed.");
            ++unplacedCounter;
            for (int g = 0; g < ring.getAtomCount(); ++g) {
                ring.getAtom(g).setFlag(1, false);
            }
        }
        this.logger.debug("There are " + unplacedCounter + " unplaced Rings.");
    }

    public void setBondLength(double bondLength) {
        this.bondLength = bondLength;
    }

    public double getBondLength() {
        return this.bondLength;
    }

    public IAtom getOtherBondAtom(IAtom atom, IBond bond) {
        if (!bond.contains(atom)) {
            return null;
        }
        if (bond.getAtom(0).equals(atom)) {
            return bond.getAtom(1);
        }
        return bond.getAtom(0);
    }
}

