/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.MDLValence;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

@TestClass(value="org.openscience.cdk.io.MDLV2000WriterTest")
public class MDLV2000Writer
extends DefaultChemObjectWriter {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV2000Writer.class);
    private Pattern NUMERED_R_GROUP = Pattern.compile("R(\\d+)");
    private static final int NN8 = 8;
    private static final int WIDTH = 3;
    private BooleanIOSetting forceWriteAs2DCoords;
    private BooleanIOSetting writeAromaticBondTypes;
    @Deprecated
    private BooleanIOSetting writeQueryFormatValencies;
    private BufferedWriter writer;

    public MDLV2000Writer(Writer out) {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        this.initIOSettings();
    }

    public MDLV2000Writer(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public MDLV2000Writer() {
        this(new StringWriter());
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IAtomContainer.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (!IChemModel.class.equals(interfaces[i])) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        this.customizeJob();
        try {
            if (object instanceof IChemFile) {
                this.writeChemFile((IChemFile)object);
                return;
            }
            if (object instanceof IChemModel) {
                IChemFile file = object.getBuilder().newInstance(IChemFile.class, new Object[0]);
                IChemSequence sequence = object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
                sequence.addChemModel((IChemModel)object);
                file.addChemSequence(sequence);
                this.writeChemFile(file);
                return;
            }
            if (object instanceof IAtomContainer) {
                this.writeMolecule((IAtomContainer)object);
                return;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            logger.debug(ex);
            throw new CDKException("Exception while writing MDL file: " + ex.getMessage(), ex);
        }
        throw new CDKException("Only supported is writing of IChemFile, IChemModel, and IAtomContainer objects.");
    }

    private void writeChemFile(IChemFile file) throws Exception {
        IAtomContainer bigPile = file.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtomContainer container : ChemFileManipulator.getAllAtomContainers(file)) {
            bigPile.add(container);
            if (container.getProperty("cdk:Title") != null) {
                if (bigPile.getProperty("cdk:Title") != null) {
                    bigPile.setProperty("cdk:Title", bigPile.getProperty("cdk:Title") + "; " + container.getProperty("cdk:Title"));
                } else {
                    bigPile.setProperty("cdk:Title", container.getProperty("cdk:Title"));
                }
            }
            if (container.getProperty("cdk:Remark") == null) continue;
            if (bigPile.getProperty("cdk:Remark") != null) {
                bigPile.setProperty("cdk:Remark", bigPile.getProperty("cdk:Remark") + "; " + container.getProperty("cdk:Remark"));
                continue;
            }
            bigPile.setProperty("cdk:Remark", container.getProperty("cdk:Remark"));
        }
        this.writeMolecule(bigPile);
    }

    public void writeMolecule(IAtomContainer container) throws Exception {
        int i;
        String line = "";
        TreeMap<Integer, Integer> rgroups = null;
        TreeMap<Integer, String> aliases = null;
        String title = (String)container.getProperty("cdk:Title");
        if (title == null) {
            title = "";
        }
        if (title.length() > 80) {
            title = title.substring(0, 80);
        }
        this.writer.write(title);
        this.writer.newLine();
        this.writer.write("  CDK     ");
        this.writer.write(new SimpleDateFormat("MMddyyHHmm").format(System.currentTimeMillis()));
        this.writer.newLine();
        String comment = (String)container.getProperty("cdk:Remark");
        if (comment == null) {
            comment = "";
        }
        if (comment.length() > 80) {
            comment = comment.substring(0, 80);
        }
        this.writer.write(comment);
        this.writer.newLine();
        line = line + MDLV2000Writer.formatMDLInt(container.getAtomCount(), 3);
        line = line + MDLV2000Writer.formatMDLInt(container.getBondCount(), 3);
        line = line + "  0  0  0  0  0  0  0  0999 V2000";
        this.writer.write(line);
        this.writer.newLine();
        for (int f = 0; f < container.getAtomCount(); ++f) {
            IAtom atom = container.getAtom(f);
            line = "";
            if (atom.getPoint3d() != null && !this.forceWriteAs2DCoords.isSet()) {
                line = line + MDLV2000Writer.formatMDLFloat((float)atom.getPoint3d().x);
                line = line + MDLV2000Writer.formatMDLFloat((float)atom.getPoint3d().y);
                line = line + MDLV2000Writer.formatMDLFloat((float)atom.getPoint3d().z) + " ";
            } else if (atom.getPoint2d() != null) {
                line = line + MDLV2000Writer.formatMDLFloat((float)atom.getPoint2d().x);
                line = line + MDLV2000Writer.formatMDLFloat((float)atom.getPoint2d().y);
                line = line + "    0.0000 ";
            } else {
                line = line + MDLV2000Writer.formatMDLFloat(0.0f);
                line = line + MDLV2000Writer.formatMDLFloat(0.0f);
                line = line + MDLV2000Writer.formatMDLFloat(0.0f) + " ";
            }
            if (container.getAtom(f) instanceof IPseudoAtom) {
                IPseudoAtom pseudoAtom = (IPseudoAtom)container.getAtom(f);
                String label = pseudoAtom.getLabel();
                if (label == null) {
                    label = "";
                }
                Matcher matcher = this.NUMERED_R_GROUP.matcher(label);
                if (pseudoAtom.getSymbol().equals("R") && !label.isEmpty() && matcher.matches()) {
                    line = line + "R# ";
                    if (rgroups == null) {
                        rgroups = new TreeMap<Integer, Integer>();
                    }
                    rgroups.put(f + 1, Integer.parseInt(matcher.group(1)));
                } else if (label.length() > 3) {
                    if (aliases == null) {
                        aliases = new TreeMap<Integer, String>();
                    }
                    aliases.put(f + 1, label);
                    line = line + MDLV2000Writer.formatMDLString(atom.getSymbol(), 3);
                } else {
                    line = !label.isEmpty() ? line + MDLV2000Writer.formatMDLString(label, 3) : line + MDLV2000Writer.formatMDLString(atom.getSymbol(), 3);
                }
            } else {
                line = line + MDLV2000Writer.formatMDLString(container.getAtom(f).getSymbol(), 3);
            }
            line = line + String.format(" 0  0  %d  0  0", atom.getStereoParity() == null ? 0 : atom.getStereoParity());
            try {
                int explicitValence = (int)AtomContainerManipulator.getBondOrderSum(container, atom);
                int charge = atom.getFormalCharge() == null ? 0 : atom.getFormalCharge();
                Integer element = atom.getAtomicNumber();
                if (element == null) {
                    line = line + MDLV2000Writer.formatMDLInt(0, 3);
                } else {
                    int actual;
                    int actual2;
                    int valence;
                    int implied = MDLValence.implicitValence(element, charge, explicitValence);
                    line = atom.getValency() != null && atom.getImplicitHydrogenCount() != null ? ((valence = atom.getValency().intValue()) != (actual2 = explicitValence + atom.getImplicitHydrogenCount()) || implied == atom.getValency() ? line + MDLV2000Writer.formatMDLInt(0, 3) : (valence == 0 ? line + MDLV2000Writer.formatMDLInt(15, 3) : (valence > 0 && valence < 15 ? line + MDLV2000Writer.formatMDLInt(valence, 3) : line + MDLV2000Writer.formatMDLInt(0, 3)))) : (atom.getImplicitHydrogenCount() != null ? (implied == (actual = explicitValence + atom.getImplicitHydrogenCount()) ? line + MDLV2000Writer.formatMDLInt(0, 3) : (actual == 0 ? line + MDLV2000Writer.formatMDLInt(15, 3) : (actual > 0 && actual < 15 ? line + MDLV2000Writer.formatMDLInt(actual, 3) : line + MDLV2000Writer.formatMDLInt(0, 3)))) : (implied == (valence = atom.getValency().intValue()) ? line + MDLV2000Writer.formatMDLInt(0, 3) : (valence == 0 ? line + MDLV2000Writer.formatMDLInt(15, 3) : (valence > 0 && valence < 15 ? line + MDLV2000Writer.formatMDLInt(valence, 3) : line + MDLV2000Writer.formatMDLInt(0, 3)))));
                }
            }
            catch (RuntimeException e) {
                line = line + MDLV2000Writer.formatMDLInt(0, 3);
            }
            line = line + "  0  0  0";
            if (container.getAtom(f).getProperty("cdk:AtomAtomMapping") != null) {
                Object atomAtomMapping = container.getAtom(f).getProperty("cdk:AtomAtomMapping");
                if (atomAtomMapping instanceof String) {
                    try {
                        int value = Integer.parseInt((String)atomAtomMapping);
                        line = line + MDLV2000Writer.formatMDLInt(value, 3);
                    }
                    catch (NumberFormatException exception) {
                        line = line + MDLV2000Writer.formatMDLInt(0, 3);
                        logger.warn("Skipping atom-atom mapping, invalid value: " + atomAtomMapping);
                    }
                } else if (atomAtomMapping instanceof Integer) {
                    int value = (Integer)atomAtomMapping;
                    line = line + MDLV2000Writer.formatMDLInt(value, 3);
                } else {
                    line = line + MDLV2000Writer.formatMDLInt(0, 3);
                }
            } else {
                line = line + MDLV2000Writer.formatMDLInt(0, 3);
            }
            line = line + "  0  0";
            this.writer.write(line);
            this.writer.newLine();
        }
        for (IBond bond : container.bonds()) {
            int bondType;
            if (bond.getAtomCount() != 2) {
                logger.warn("Skipping bond with more/less than two atoms: " + bond);
                continue;
            }
            if (bond.getStereo() == IBond.Stereo.UP_INVERTED || bond.getStereo() == IBond.Stereo.DOWN_INVERTED || bond.getStereo() == IBond.Stereo.UP_OR_DOWN_INVERTED) {
                line = MDLV2000Writer.formatMDLInt(container.getAtomNumber(bond.getAtom(1)) + 1, 3);
                line = line + MDLV2000Writer.formatMDLInt(container.getAtomNumber(bond.getAtom(0)) + 1, 3);
            } else {
                line = MDLV2000Writer.formatMDLInt(container.getAtomNumber(bond.getAtom(0)) + 1, 3);
                line = line + MDLV2000Writer.formatMDLInt(container.getAtomNumber(bond.getAtom(1)) + 1, 3);
            }
            if (this.writeAromaticBondTypes.isSet() && bond.getFlag(32)) {
                bondType = 4;
            } else {
                if (IBond.Order.QUADRUPLE == bond.getOrder()) {
                    throw new CDKException("MDL molfiles do not support quadruple bonds.");
                }
                bondType = bond.getOrder().numeric();
            }
            line = line + MDLV2000Writer.formatMDLInt(bondType, 3);
            line = line + "  ";
            switch (bond.getStereo()) {
                case UP: {
                    line = line + "1";
                    break;
                }
                case UP_INVERTED: {
                    line = line + "1";
                    break;
                }
                case DOWN: {
                    line = line + "6";
                    break;
                }
                case DOWN_INVERTED: {
                    line = line + "6";
                    break;
                }
                case UP_OR_DOWN: {
                    line = line + "4";
                    break;
                }
                case UP_OR_DOWN_INVERTED: {
                    line = line + "4";
                    break;
                }
                case E_OR_Z: {
                    line = line + "3";
                    break;
                }
                default: {
                    line = line + "0";
                }
            }
            line = line + "  0  0  0 ";
            this.writer.write(line);
            this.writer.newLine();
        }
        for (i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            if (atom.getProperty("cdk:Comment") == null || !(atom.getProperty("cdk:Comment") instanceof String) || ((String)atom.getProperty("cdk:Comment")).trim().equals("")) continue;
            this.writer.write("V  ");
            this.writer.write(MDLV2000Writer.formatMDLInt(i + 1, 3));
            this.writer.write(" ");
            this.writer.write((String)atom.getProperty("cdk:Comment"));
            this.writer.newLine();
        }
        for (i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            Integer charge = atom.getFormalCharge();
            if (charge == null || charge == 0) continue;
            this.writer.write("M  CHG  1 ");
            this.writer.write(MDLV2000Writer.formatMDLInt(i + 1, 3));
            this.writer.write(" ");
            this.writer.write(MDLV2000Writer.formatMDLInt(charge, 3));
            this.writer.newLine();
        }
        if (container.getSingleElectronCount() > 0) {
            LinkedHashMap<Integer, SPIN_MULTIPLICITY> atomIndexSpinMap = new LinkedHashMap<Integer, SPIN_MULTIPLICITY>();
            block23: for (int i2 = 0; i2 < container.getAtomCount(); ++i2) {
                int eCount = container.getConnectedSingleElectronsCount(container.getAtom(i2));
                switch (eCount) {
                    case 0: {
                        continue block23;
                    }
                    case 1: {
                        atomIndexSpinMap.put(i2, SPIN_MULTIPLICITY.SINGLET);
                        continue block23;
                    }
                    case 2: {
                        atomIndexSpinMap.put(i2, SPIN_MULTIPLICITY.DOUBLET);
                        continue block23;
                    }
                    case 3: {
                        atomIndexSpinMap.put(i2, SPIN_MULTIPLICITY.TRIPLET);
                        continue block23;
                    }
                    default: {
                        logger.debug("Invalid number of radicals found: " + eCount);
                    }
                }
            }
            Iterator<Map.Entry<Integer, SPIN_MULTIPLICITY>> iterator = atomIndexSpinMap.entrySet().iterator();
            for (int i3 = 0; i3 < atomIndexSpinMap.size(); i3 += 8) {
                if (atomIndexSpinMap.size() - i3 <= 8) {
                    this.writer.write("M  RAD" + MDLV2000Writer.formatMDLInt(atomIndexSpinMap.size() - i3, 3));
                    this.writeRadicalPattern(iterator, i3);
                } else {
                    this.writer.write("M  RAD" + MDLV2000Writer.formatMDLInt(8, 3));
                    this.writeRadicalPattern(iterator, i3);
                }
                this.writer.newLine();
            }
        }
        for (int i4 = 0; i4 < container.getAtomCount(); ++i4) {
            Integer atomicMass;
            IAtom atom = container.getAtom(i4);
            if (atom instanceof IPseudoAtom || (atomicMass = atom.getMassNumber()) == null) continue;
            int majorMass = Isotopes.getInstance().getMajorIsotope(atom.getSymbol()).getMassNumber();
            if (atomicMass == majorMass) continue;
            this.writer.write("M  ISO  1 ");
            this.writer.write(MDLV2000Writer.formatMDLInt(i4 + 1, 3));
            this.writer.write(" ");
            this.writer.write(MDLV2000Writer.formatMDLInt(atomicMass, 3));
            this.writer.newLine();
        }
        if (rgroups != null) {
            StringBuilder rgpLine = new StringBuilder();
            int cnt = 0;
            for (Map.Entry e : rgroups.entrySet()) {
                rgpLine.append(MDLV2000Writer.formatMDLInt((Integer)e.getKey(), 4));
                rgpLine.append(MDLV2000Writer.formatMDLInt((Integer)e.getValue(), 4));
                if (++cnt != 8) continue;
                rgpLine.insert(0, "M  RGP" + MDLV2000Writer.formatMDLInt(cnt, 3));
                this.writer.write(rgpLine.toString());
                this.writer.newLine();
                rgpLine = new StringBuilder();
                cnt = 0;
            }
            if (cnt != 0) {
                rgpLine.insert(0, "M  RGP" + MDLV2000Writer.formatMDLInt(cnt, 3));
                this.writer.write(rgpLine.toString());
                this.writer.newLine();
            }
        }
        if (aliases != null) {
            for (Map.Entry e : aliases.entrySet()) {
                this.writer.write("A" + MDLV2000Writer.formatMDLInt((Integer)e.getKey(), 5));
                this.writer.newLine();
                String label = (String)e.getValue();
                if (label.length() > 70) {
                    label = label.substring(0, 70);
                }
                this.writer.write(label);
                this.writer.newLine();
            }
        }
        this.writer.write("M  END");
        this.writer.newLine();
        this.writer.flush();
    }

    private void writeRadicalPattern(Iterator<Map.Entry<Integer, SPIN_MULTIPLICITY>> iterator, int i) throws IOException {
        Map.Entry<Integer, SPIN_MULTIPLICITY> entry = iterator.next();
        this.writer.write(" ");
        this.writer.write(MDLV2000Writer.formatMDLInt(entry.getKey() + 1, 3));
        this.writer.write(" ");
        this.writer.write(MDLV2000Writer.formatMDLInt(entry.getValue().getValue(), 3));
        if (++i < 8 && iterator.hasNext()) {
            this.writeRadicalPattern(iterator, i);
        }
    }

    protected static String formatMDLInt(int i, int l) {
        String s = "";
        String fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setParseIntegerOnly(true);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(l);
        nf.setGroupingUsed(false);
        s = nf.format(i);
        l -= s.length();
        for (int f = 0; f < l; ++f) {
            fs = fs + " ";
        }
        fs = fs + s;
        return fs;
    }

    protected static String formatMDLFloat(float fl) {
        String s = "";
        String fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(4);
        nf.setMaximumFractionDigits(4);
        nf.setGroupingUsed(false);
        s = nf.format(fl);
        int l = 10 - s.length();
        for (int f = 0; f < l; ++f) {
            fs = fs + " ";
        }
        fs = fs + s;
        return fs;
    }

    protected static String formatMDLString(String s, int le) {
        if ((s = s.trim()).length() > le) {
            return s.substring(0, le);
        }
        int l = le - s.length();
        for (int f = 0; f < l; ++f) {
            s = s + " ";
        }
        return s;
    }

    private void initIOSettings() {
        this.forceWriteAs2DCoords = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("ForceWriteAs2DCoordinates", IOSetting.Importance.LOW, "Should coordinates always be written as 2D?", "false"));
        this.writeAromaticBondTypes = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("WriteAromaticBondTypes", IOSetting.Importance.LOW, "Should aromatic bonds be written as bond type 4?", "false"));
        this.writeQueryFormatValencies = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("WriteQueryFormatValencies", IOSetting.Importance.LOW, "Should valencies be written in the MDL Query format? (deprecated)", "false"));
    }

    public void customizeJob() {
        for (IOSetting setting : this.getSettings()) {
            this.fireIOSettingQuestion(setting);
        }
    }

    public static enum SPIN_MULTIPLICITY {
        NONE(0, 0),
        SINGLET(2, 1),
        DOUBLET(1, 2),
        TRIPLET(3, 2);

        private final int value;
        private final int singleElectrons;

        private SPIN_MULTIPLICITY(int value, int singleElectrons) {
            this.value = value;
            this.singleElectrons = singleElectrons;
        }

        public int getValue() {
            return this.value;
        }

        public int getSingleElectrons() {
            return this.singleElectrons;
        }

        public static SPIN_MULTIPLICITY ofValue(int value) throws CDKException {
            switch (value) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return DOUBLET;
                }
                case 2: {
                    return SINGLET;
                }
                case 3: {
                    return TRIPLET;
                }
            }
            throw new CDKException("unknown spin multiplicity: " + value);
        }
    }
}

