/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

@TestClass(value="org.openscience.cdk.fingerprint.ExtendedFingerprinterTest")
public class ExtendedFingerprinter
implements IFingerprinter {
    private final int RESERVED_BITS = 25;
    private Fingerprinter fingerprinter = null;

    public ExtendedFingerprinter() {
        this(1024, 8);
    }

    public ExtendedFingerprinter(int size) {
        this(size, 8);
    }

    public ExtendedFingerprinter(int size, int searchDepth) {
        this.fingerprinter = new Fingerprinter(size - 25, searchDepth);
    }

    @Override
    @TestMethod(value="testgetBitFingerprint_IAtomContainer")
    public IBitFingerprint getBitFingerprint(IAtomContainer container) throws CDKException {
        return this.getBitFingerprint(container, null, null);
    }

    @Override
    @TestMethod(value="testGetRawFingerprint")
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @TestMethod(value="testgetBitFingerprint_IAtomContainer_IRingSet_List")
    public IBitFingerprint getBitFingerprint(IAtomContainer atomContainer, IRingSet ringSet, List<IRingSet> rslist) throws CDKException {
        int i;
        int i2;
        IAtomContainer container;
        try {
            container = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone input");
        }
        IBitFingerprint fingerprint = this.fingerprinter.getBitFingerprint(container);
        int size = this.getSize();
        double weight = MolecularFormulaManipulator.getTotalNaturalAbundance(MolecularFormulaManipulator.getMolecularFormula(container));
        for (i2 = 1; i2 < 11; ++i2) {
            if (!(weight > (double)(100 * i2))) continue;
            fingerprint.set(size - 26 + i2);
        }
        if (ringSet == null) {
            ringSet = Cycles.sssr(container).toRingSet();
            rslist = RingPartitioner.partitionRings(ringSet);
        }
        for (i2 = 0; i2 < 7; ++i2) {
            if (ringSet.getAtomContainerCount() <= i2) continue;
            fingerprint.set(size - 15 + i2);
        }
        int maximumringsystemsize = 0;
        for (i = 0; i < rslist.size(); ++i) {
            if (rslist.get(i).getAtomContainerCount() <= maximumringsystemsize) continue;
            maximumringsystemsize = rslist.get(i).getAtomContainerCount();
        }
        for (i = 0; i < maximumringsystemsize && i < 9; ++i) {
            fingerprint.set(size - 8 + i - 3);
        }
        return fingerprint;
    }

    @Override
    @TestMethod(value="testGetSize")
    public int getSize() {
        return this.fingerprinter.getSize() + 25;
    }

    @Override
    @TestMethod(value="testGetCountFingerprint")
    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        throw new UnsupportedOperationException();
    }
}

