/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.Bond;

public final class Edge {
    private final int u;
    private final int v;
    private final Bond bond;

    Edge(int u, int v, Bond bond) {
        this.u = u;
        this.v = v;
        this.bond = bond;
    }

    public int either() {
        return this.u;
    }

    public int other(int x) {
        if (x == this.u) {
            return this.v;
        }
        if (x == this.v) {
            return this.u;
        }
        throw new IllegalArgumentException(this.invalidEndpointMessage(x));
    }

    public Bond bond() {
        return this.bond;
    }

    public Bond bond(int x) {
        if (x == this.u) {
            return this.bond;
        }
        if (x == this.v) {
            return this.bond.inverse();
        }
        throw new IllegalArgumentException(this.invalidEndpointMessage(x));
    }

    Edge inverse() {
        return this.bond.inverse().edge(this.u, this.v);
    }

    private String invalidEndpointMessage(int x) {
        return "Vertex " + x + ", is not an endpoint of the edge " + this.toString();
    }

    public int hashCode() {
        return this.u ^ this.v;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Edge o = (Edge)other;
        return this.u == o.u && this.v == o.v && this.bond.equals((Object)o.bond) || this.u == o.v && this.v == o.u && this.bond.equals((Object)o.bond.inverse());
    }

    public String toString() {
        return new StringBuilder(20).append('{').append(this.u).append(", ").append(this.v).append('}').append(": '").append((Object)this.bond).append("'").toString();
    }
}

