/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.io.Serializable;
import java.util.Arrays;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.invariant.MorganNumbersTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.isomorphism.IsomorphismTesterTest")
public class IsomorphismTester
implements Serializable {
    private static final long serialVersionUID = 2499779110996693974L;
    long[] baseTable;
    long[] sortedBaseTable;
    long[] compareTable;
    long[] sortedCompareTable;
    IAtomContainer base = null;
    IAtomContainer compare = null;

    public IsomorphismTester() {
    }

    public IsomorphismTester(IAtomContainer mol) throws NoSuchAtomException {
        this.setBaseTable(mol);
    }

    @TestMethod(value="testIsIsomorphic_IMolecule_IMolecule")
    public boolean isIsomorphic(IAtomContainer mol1, IAtomContainer mol2) {
        this.setBaseTable(mol1);
        return this.isIsomorphic(mol2);
    }

    @TestMethod(value="testIsIsomorphic_IMolecule")
    public boolean isIsomorphic(IAtomContainer mol2) {
        int f;
        IAtom atom1 = null;
        IAtom atom2 = null;
        this.setCompareTable(mol2);
        for (f = 0; f < this.sortedBaseTable.length; ++f) {
            if (this.sortedBaseTable[f] == this.sortedCompareTable[f]) continue;
            return false;
        }
        for (f = 0; f < this.baseTable.length; ++f) {
            boolean found = false;
            for (int g = 0; g < this.compareTable.length; ++g) {
                if (this.baseTable[f] != this.compareTable[g]) continue;
                atom1 = this.base.getAtom(f);
                atom2 = this.compare.getAtom(g);
                if (!atom1.getSymbol().equals(atom2.getSymbol()) && atom1.getImplicitHydrogenCount() == atom2.getImplicitHydrogenCount()) {
                    return false;
                }
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void setBaseTable(IAtomContainer mol) {
        this.base = mol;
        this.baseTable = MorganNumbersTools.getMorganNumbers(this.base);
        this.sortedBaseTable = new long[this.baseTable.length];
        System.arraycopy(this.baseTable, 0, this.sortedBaseTable, 0, this.baseTable.length);
        Arrays.sort(this.sortedBaseTable);
    }

    private void setCompareTable(IAtomContainer mol) {
        this.compare = mol;
        this.compareTable = MorganNumbersTools.getMorganNumbers(this.compare);
        this.sortedCompareTable = new long[this.compareTable.length];
        System.arraycopy(this.compareTable, 0, this.sortedCompareTable, 0, this.compareTable.length);
        Arrays.sort(this.sortedCompareTable);
    }
}

