/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.element.AbstractMolecule;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLAtomArray;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLBondArray;
import org.xmlcml.cml.element.CMLFormula;
import org.xmlcml.cml.element.CMLLabel;
import org.xmlcml.cml.element.CMLName;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Real2Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLMolecule
extends AbstractMolecule {
    public static final String NS = "cml:molecule";
    public static final int COORD2 = 2;
    public static final int COORD3 = 3;
    public static final String D2 = "2D";
    public static final String D3 = "3D";
    static final Logger logger = Logger.getLogger(CMLMolecule.class);
    Map<String, List<CMLAtom>> childMoleculeAtomMap = null;
    Map<CMLAtom, CMLMolecule> atomChildMoleculeMap = null;

    public static CMLMolecule getMoleculeAncestor(CMLElement elem) {
        CMLMolecule mol = null;
        ParentNode parent = elem;
        while ((parent = parent.getParent()) != null && !(parent instanceof Document)) {
            if (!(parent instanceof CMLMolecule)) continue;
            mol = (CMLMolecule)parent;
            break;
        }
        return mol;
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLMolecule();
    }

    public CMLMolecule() {
        this.init();
    }

    public static CMLMolecule createMoleculeWithId(String id) {
        CMLMolecule molecule = new CMLMolecule();
        molecule.setId(id);
        return molecule;
    }

    public CMLMolecule(CMLMolecule old) {
        super(old);
        CMLBondArray bondArray;
        this.init();
        CMLAtomArray atomArray = this.getAtomArray();
        if (atomArray != null) {
            atomArray.indexAtoms();
        }
        if ((bondArray = this.getBondArray()) != null) {
            bondArray.indexBonds();
        }
    }

    @Deprecated
    public void addAtom(CMLAtom atom, boolean check) throws RuntimeException {
        this.addAtom(atom);
    }

    public void addAtom(CMLAtom atom) throws RuntimeException {
        if (atom != null) {
            CMLAtomArray atomArray = this.getOrCreateAtomArray();
            String id = atom.getId();
            if (id == null) {
                throw new RuntimeException("Null atom ID");
            }
            CMLAtom oldAtom = atomArray.getAtomById(id);
            if (oldAtom == null) {
                atomArray.addAtom(atom);
            }
        } else {
            throw new RuntimeException("Cannot add null atom");
        }
    }

    public CMLAtom deleteAtom(CMLAtom atom) {
        CMLAtom deletedAtom = null;
        if (this.isMoleculeContainer()) {
            this.getAtomChildMoleculeMap();
            CMLMolecule molecule = this.atomChildMoleculeMap.get(atom);
            if (molecule != null) {
                molecule.deleteAtom(atom);
                deletedAtom = atom;
                this.atomChildMoleculeMap.remove(atom);
            }
        } else {
            CMLAtomArray atomArray = this.getAtomArray();
            if (atomArray != null) {
                deletedAtom = atomArray.removeAtom(atom);
            }
        }
        this.removeAtomFromChildMoleculeAtomMap(atom);
        return deletedAtom;
    }

    private void removeAtomFromChildMoleculeAtomMap(CMLAtom atom) {
        this.getChildMoleculeAtomMap();
        String id = atom.getId();
        List<CMLAtom> atomList = this.childMoleculeAtomMap.get(id);
        if (atomList != null && atomList.size() > 1) {
            atomList.remove(atom);
        } else {
            this.childMoleculeAtomMap.remove(id);
        }
    }

    private void getAtomChildMoleculeMap() {
        if (this.atomChildMoleculeMap == null) {
            this.atomChildMoleculeMap = new HashMap<CMLAtom, CMLMolecule>();
            CMLElements<CMLMolecule> moleculeList = this.getMoleculeElements();
            for (CMLMolecule molecule : moleculeList) {
                List<CMLAtom> atomList = molecule.getAtoms();
                for (CMLAtom atom : atomList) {
                    this.atomChildMoleculeMap.put(atom, molecule);
                }
            }
        }
    }

    @Deprecated
    public void insertAtomArray(CMLAtomArray atomArray, int pos) {
        throw new RuntimeException("append/insert atomArray forbidden");
    }

    public void removeAtomArray() {
        CMLAtomArray atomArray;
        CMLElements<CMLAtomArray> atomArrays = this.getAtomArrayElements();
        CMLAtomArray cMLAtomArray = atomArray = atomArrays.size() == 0 ? null : atomArrays.get(0);
        if (atomArray != null) {
            super.removeChild(atomArray);
            this.removeBondArray();
        }
    }

    public void insertBondArray(CMLBondArray bondArray, int pos) {
        throw new RuntimeException("append/insert bondArray forbidden");
    }

    public void removeBondArray() {
        CMLBondArray bondArray;
        CMLElements<CMLBondArray> bondArrays = this.getBondArrayElements();
        CMLBondArray cMLBondArray = bondArray = bondArrays.size() == 0 ? null : bondArrays.get(0);
        if (bondArray != null) {
            super.removeChild(bondArray);
        }
    }

    @Deprecated
    public void addBond(CMLBond bond, boolean check) throws RuntimeException {
        this.addBond(bond);
    }

    public void addBond(CMLBond bond) throws RuntimeException {
        CMLBondArray bondArray = this.getOrCreateBondArray();
        String id = bond.getId();
        if (id == null) {
            String[] atomRefs2 = bond.getAtomRefs2();
            id = atomRefs2[0] + "_" + atomRefs2[1];
            bond.setId(id);
        } else {
            CMLBond oldBond = this.getBondById(id);
            if (oldBond != null) {
                if (oldBond != bond) {
                    throw new RuntimeException("Bond id not unique: " + id);
                }
                return;
            }
        }
        bondArray.addBond(bond);
    }

    public CMLBond deleteBond(CMLBond bond) {
        CMLBond deletedBond = null;
        if (this.isMoleculeContainer()) {
            CMLMolecule mol;
            Iterator<CMLMolecule> i$ = this.getMoleculeElements().iterator();
            while (i$.hasNext() && (deletedBond = (mol = i$.next()).deleteBond(bond)) == null) {
            }
        } else {
            CMLBondArray bondArray = this.getBondArray();
            if (bondArray != null) {
                deletedBond = bondArray.removeBond(bond);
            }
        }
        return deletedBond;
    }

    public CMLBond deleteBond(CMLAtom atom1, CMLAtom atom2) {
        CMLBond deletedBond = this.getBond(atom1, atom2);
        if (deletedBond != null) {
            this.deleteBond(deletedBond);
        }
        return deletedBond;
    }

    public void appendMolecule(CMLMolecule newMol) {
        ParentNode parent = newMol.getParent();
        if (parent != null && parent instanceof Document) {
            Element dummy = new Element("m_dummy");
            ((Document)parent).replaceChild(newMol, dummy);
        }
        newMol.detach();
        if (this.getMoleculeCount() == 0) {
            CMLMolecule thisMol = new CMLMolecule(this);
            for (int i = 0; i < this.getAttributeCount(); ++i) {
                Attribute att = this.getAttribute(i);
                if (att.getLocalName().equals("id")) continue;
                this.removeAttribute(this.getAttribute(i));
            }
            this.removeChildren();
            this.appendChild(thisMol);
        }
        this.appendChild(newMol);
    }

    public void deleteMolecule(CMLMolecule molecule) {
        int nChildMolecule = this.getMoleculeCount();
        if (nChildMolecule == 0) {
            throw new RuntimeException("molecule has no children to delete");
        }
        int idx = this.indexOf(molecule);
        if (idx == -1) {
            throw new RuntimeException("Molecule is not a child of this Molecule");
        }
        if (nChildMolecule == 1) {
            throw new RuntimeException("Cannot have single child molecule");
        }
        if (nChildMolecule == 2) {
            molecule.detach();
        } else {
            molecule.detach();
        }
        this.removeAtomsFromAtomMap(molecule.getAtoms());
    }

    private void removeAtomsFromAtomMap(List<CMLAtom> atomList) {
        this.getChildMoleculeAtomMap();
        for (CMLAtom atom : atomList) {
            this.childMoleculeAtomMap.remove(atom);
        }
    }

    public void normalizeSingleMoleculeChild() {
        if (this.getMoleculeCount() == 1) {
            CMLMolecule childMolecule = (CMLMolecule)this.getChildCMLElements("molecule").get(0);
            CMLUtil.transferChildren(childMolecule, this);
            childMolecule.detach();
        }
    }

    public void appendChild(CMLMolecule molecule) {
        this.addMolecule(molecule);
    }

    public void removeChild(CMLMolecule molecule) {
        this.deleteMolecule(molecule);
    }

    public void appendChild(CMLAtom atom) {
        this.addAtom(atom);
    }

    public void removeChild(CMLAtom atom) {
        this.deleteAtom(atom);
    }

    public void appendChild(CMLBond bond) {
        this.addBond(bond);
    }

    public void removeChild(CMLBond bond) {
        this.deleteBond(bond);
    }

    public void appendToIds(String s) {
        String id = this.getId();
        if (id != null && id.length() > 0) {
            this.setId(id + s);
        } else {
            this.setId("m" + s);
        }
        for (CMLAtom atom : this.getAtoms()) {
            id = atom.getId();
            if (id == null || id.length() <= 0) continue;
            atom.resetId(id + s);
        }
        for (CMLBond bond : this.getBonds()) {
            String[] refs;
            id = bond.getId();
            if (id != null && id.length() > 0) {
                bond.setId(id + s);
            }
            if ((refs = bond.getAtomRefs2()) != null) {
                int j = refs.length - 1;
                while (j >= 0) {
                    int n = j--;
                    refs[n] = refs[n] + s;
                }
            }
            bond.setAtomRefs2(refs);
        }
    }

    public int calculateFormalCharge() {
        int formalCharge = 0;
        for (CMLAtom atom : this.getAtoms()) {
            formalCharge += atom.getFormalCharge();
        }
        return formalCharge;
    }

    @Override
    public Node copy() {
        CMLMolecule newMolecule = new CMLMolecule(this);
        return newMolecule;
    }

    @Override
    public void finishMakingElement(Element parent) {
        super.finishMakingElement(parent);
    }

    void indexAtoms() {
        if (this.isMoleculeContainer()) {
            for (CMLMolecule mol : this.getMoleculeElements()) {
                mol.indexAtoms();
            }
        } else {
            CMLAtomArray atomArray = this.getOrCreateAtomArray();
            if (atomArray != null) {
                atomArray.indexAtoms();
            }
        }
    }

    void indexBonds() {
        if (this.isMoleculeContainer()) {
            for (CMLMolecule mol : this.getMoleculeElements()) {
                mol.indexBonds();
            }
        } else {
            CMLBondArray bondArray = this.getOrCreateBondArray();
            bondArray.indexBonds();
        }
    }

    void updateLigands() {
        if (this.isMoleculeContainer()) {
            for (CMLMolecule mol : this.getMoleculeElements()) {
                mol.updateLigands();
            }
        } else {
            CMLBondArray bondArray = this.getBondArray();
            if (bondArray != null) {
                bondArray.updateLigands();
            }
        }
    }

    public CMLAtom getAtom(int i) {
        List<CMLAtom> atoms = this.getAtoms();
        return i < 0 || i >= atoms.size() ? null : atoms.get(i);
    }

    public CMLAtomArray getAtomArray() {
        return (CMLAtomArray)this.getFirstCMLChild("atomArray");
    }

    public Map<String, CMLAtom> getAtomMap() {
        Map<String, CMLAtom> map = null;
        if (!this.isMoleculeContainer()) {
            CMLAtomArray atomArray = this.getAtomArray();
            map = atomArray == null ? null : atomArray.getAtomMap();
        }
        return map;
    }

    public Map<String, CMLBond> getBondMap() {
        Map<String, CMLBond> map = null;
        if (!this.isMoleculeContainer()) {
            CMLBondArray bondArray = this.getBondArray();
            map = bondArray == null ? null : bondArray.getBondMap();
        }
        return map;
    }

    public Map<String, CMLBond> getBondIdMap() {
        Map<String, CMLBond> map = null;
        if (!this.isMoleculeContainer()) {
            CMLBondArray bondArray = this.getBondArray();
            map = bondArray == null ? null : bondArray.getBondIdMap();
        }
        return map;
    }

    public CMLAtom getAtomById(String id) {
        CMLAtom atom = null;
        if (id != null) {
            CMLAtomArray atomArray = this.getAtomArray();
            if (atomArray != null) {
                if (atomArray.atomMap.size() != atomArray.getAtomElements().size()) {
                    atomArray.indexAtoms();
                }
                atom = atomArray.getAtomById(id);
            } else if (this.getMoleculeCount() > 0) {
                this.getChildMoleculeAtomMap();
                List<CMLAtom> atomList = this.childMoleculeAtomMap.get(id);
                if (atomList != null && atomList.size() == 1) {
                    atom = atomList.get(0);
                }
            }
        }
        return atom;
    }

    public CMLAtom getAtomByIdXX(String id) {
        CMLAtom atom = null;
        if (this.getMoleculeCount() > 0) {
            this.getChildMoleculeAtomMap();
            List<CMLAtom> atomList = this.childMoleculeAtomMap.get(id);
            if (atomList != null && atomList.size() == 1) {
                atom = atomList.get(0);
            }
        } else {
            CMLAtomArray atomArray = this.getAtomArray();
            if (atomArray != null) {
                atom = atomArray.getAtomById(id);
            }
        }
        return atom;
    }

    public List<CMLAtom> getAtomsById(String id) {
        this.getChildMoleculeAtomMap();
        return this.childMoleculeAtomMap.get(id);
    }

    public static List<CMLMolecule> getChildMoleculeList(CMLMolecule mol) {
        ArrayList<CMLMolecule> moleculeList = new ArrayList<CMLMolecule>();
        Elements mols = mol.getChildElements("molecule", "http://www.xml-cml.org/schema");
        for (int i = 0; i < mols.size(); ++i) {
            moleculeList.add((CMLMolecule)mols.get(i));
        }
        return moleculeList;
    }

    private Map<String, List<CMLAtom>> getChildMoleculeAtomMap() {
        if (this.childMoleculeAtomMap == null) {
            this.childMoleculeAtomMap = new HashMap<String, List<CMLAtom>>();
            if (this.isMoleculeContainer()) {
                CMLElements<CMLMolecule> molList = this.getMoleculeElements();
                for (CMLMolecule molecule : molList) {
                    molecule.indexAtomIds(this.childMoleculeAtomMap);
                }
            } else {
                this.indexAtomIds(this.childMoleculeAtomMap);
            }
        }
        return this.childMoleculeAtomMap;
    }

    private void indexAtomIds(Map<String, List<CMLAtom>> childMoleculeAtomMap) {
        List<CMLAtom> atomList = this.getAtoms();
        for (CMLAtom atom : atomList) {
            String id = atom.getId();
            List<CMLAtom> aList = childMoleculeAtomMap.get(id);
            if (aList == null) {
                aList = new ArrayList<CMLAtom>();
                childMoleculeAtomMap.put(id, aList);
            }
            aList.add(atom);
        }
    }

    public boolean hasCloseContacts() {
        return this.getCloseContacts().size() > 0;
    }

    public Map<CMLAtom, CMLAtom> getCloseContacts() {
        HashMap<CMLAtom, CMLAtom> contactMap = new HashMap<CMLAtom, CMLAtom>();
        for (CMLAtom atom : this.getAtoms()) {
            for (CMLAtom ligand : atom.getLigandAtoms()) {
                double dist;
                double valenceDist;
                if (contactMap.containsKey(ligand) || !((valenceDist = atom.getChemicalElement().getCovalentRadius() + ligand.getChemicalElement().getCovalentRadius()) / 2.0 > (dist = atom.getDistanceTo(ligand)))) continue;
                contactMap.put(atom, ligand);
            }
        }
        return contactMap;
    }

    public CMLBond getBondById(String id) {
        CMLBondArray bondArray = this.getBondArray();
        return bondArray == null ? null : bondArray.getBondById(id);
    }

    public CMLBond getBondByAtomIds(String id1, String id2) {
        CMLAtom atom1 = this.getAtomById(id1);
        CMLAtom atom2 = this.getAtomById(id2);
        return this.getBond(atom1, atom2);
    }

    public List<CMLAtom> getAtomListByIds(String[] ids) {
        ArrayList<CMLAtom> atomList = new ArrayList<CMLAtom>();
        if (!this.isMoleculeContainer() && ids != null) {
            for (String id : ids) {
                CMLAtom atom = this.getAtomById(id);
                if (atom == null) continue;
                atomList.add(atom);
            }
        }
        return atomList;
    }

    public CMLAtom getAtomByLabel(String label) {
        CMLAtom atom1 = null;
        if (label != null) {
            for (CMLAtom atom : this.getAtoms()) {
                for (CMLLabel label1 : atom.getLabelElements()) {
                    if (!label.equals(label1.getCMLValue())) continue;
                    atom1 = atom;
                    break;
                }
                if (atom1 == null) continue;
                break;
            }
        }
        return atom1;
    }

    public int getAtomCount() {
        return this.getAtoms().size();
    }

    public List<CMLAtom> getAtoms() {
        ArrayList<CMLAtom> atomList = new ArrayList<CMLAtom>();
        for (CMLMolecule molecule : this.getDescendantsOrMolecule()) {
            CMLAtomArray atomArray = molecule.getAtomArray();
            if (atomArray == null) continue;
            atomList.addAll(atomArray.getAtoms());
        }
        return atomList;
    }

    public CMLBond getBond(CMLAtom a1, CMLAtom a2) {
        String atomHash = CMLBond.atomHash(a1, a2);
        if (atomHash != null) {
            for (CMLBond bond : this.getBonds()) {
                String bondHash = CMLBond.atomHash(bond);
                if (!bondHash.equals(atomHash)) continue;
                return bond;
            }
        }
        return null;
    }

    public CMLBondArray getBondArray() {
        return (CMLBondArray)this.getFirstCMLChild("bondArray");
    }

    public int getBondCount() {
        List<CMLBond> bonds = this.getBonds();
        return bonds.size();
    }

    public List<CMLBond> getBonds() {
        ArrayList<CMLBond> bondList = new ArrayList<CMLBond>();
        for (CMLMolecule molecule : this.getDescendantsOrMolecule()) {
            CMLBondArray bondArray = molecule.getBondArray();
            if (bondArray == null) continue;
            bondList.addAll(bondArray.getBonds());
        }
        return bondList;
    }

    public int getCalculatedFormalCharge(CMLElement.FormalChargeControl control) throws RuntimeException {
        int charge = 0;
        for (CMLAtom atom : this.getAtoms()) {
            charge += atom.getFormalCharge(control);
        }
        return charge;
    }

    public Real2 calculateCentroid2D() {
        Real2Vector p2Vector = this.getCoordinates2D();
        return p2Vector.getCentroid();
    }

    public List<CMLBond> getDoubleBonds() {
        this.setNormalizedBondOrders();
        ArrayList<CMLBond> dbVector = new ArrayList<CMLBond>();
        for (CMLBond bond : this.getBonds()) {
            String order = bond.getOrder();
            if (!CMLBond.isDouble(order)) continue;
            dbVector.add(bond);
        }
        return dbVector;
    }

    public int getMoleculeCount() {
        return this.getMoleculeElements().size();
    }

    public List<CMLMolecule> getDescendantsOrMolecule() {
        ArrayList<CMLMolecule> moleculeList = new ArrayList<CMLMolecule>();
        CMLElements<CMLMolecule> moleculeElements = this.getMoleculeElements();
        if (moleculeElements.size() == 0) {
            moleculeList.add(this);
        } else {
            for (CMLMolecule molecule : moleculeElements) {
                moleculeList.add(molecule);
            }
        }
        return moleculeList;
    }

    public CMLAtomArray getOrCreateAtomArray() {
        CMLAtomArray atomArray = this.getAtomArray();
        if (atomArray == null) {
            atomArray = new CMLAtomArray();
            this.addAtomArray(atomArray);
        }
        return atomArray;
    }

    public CMLBondArray getOrCreateBondArray() {
        CMLBondArray bondArray = this.getBondArray();
        if (bondArray == null) {
            bondArray = new CMLBondArray();
            this.addBondArray(bondArray);
        }
        return bondArray;
    }

    public Real2Vector getCoordinates2D() {
        Real2Vector p2Vector = new Real2Vector();
        boolean ok = true;
        for (CMLAtom atom : this.getAtoms()) {
            Real2 p = atom.getXY2();
            if (p == null) continue;
            p2Vector.add(p);
        }
        if (!ok) {
            p2Vector = new Real2Vector();
        }
        return p2Vector;
    }

    public boolean hasCoordinates(CMLElement.CoordinateType type, boolean omitHydrogen) {
        boolean has = true;
        for (CMLAtom atom : this.getAtoms()) {
            if (omitHydrogen && "H".equals(atom.getElementType()) || (has = atom.hasCoordinates(type))) continue;
            break;
        }
        return has;
    }

    public boolean hasCoordinates(CMLElement.CoordinateType type) {
        CMLAtom atom;
        boolean has = true;
        Iterator<CMLAtom> i$ = this.getAtoms().iterator();
        while (i$.hasNext() && (has = (atom = i$.next()).hasCoordinates(type))) {
        }
        return has;
    }

    void init() {
    }

    public boolean isMoleculeContainer() {
        return this.getMoleculeElements().size() > 0;
    }

    public void multiply2DCoordsBy(double scale) {
        for (CMLAtom atom : this.getAtoms()) {
            Real2 xy = atom.getXY2();
            if (xy == null) continue;
            xy.x *= scale;
            xy.y *= scale;
            atom.setXY2(xy);
        }
    }

    public void renameAtomIDs(List<String> oldIds, List<String> newIds) {
        HashMap<String, String> mapTable = new HashMap<String, String>();
        HashMap<String, String> newTable = new HashMap<String, String>();
        List<CMLAtom> atoms = this.getAtoms();
        if (oldIds.size() != atoms.size() || newIds.size() != atoms.size()) {
            throw new RuntimeException("Lists (" + oldIds.size() + "/" + newIds.size() + ") must be same length as atomCount (" + atoms.size() + ")");
        }
        for (int i = 0; i < atoms.size(); ++i) {
            String oldId = oldIds.get(i);
            if (this.getAtomById(oldId) == null) {
                throw new RuntimeException("Unknown atom id: " + oldId);
            }
            String newId = newIds.get(i);
            if (newTable.containsKey(newId)) {
                throw new RuntimeException("Duplicate new id: " + newId);
            }
            newTable.put(newId, "");
            mapTable.put(oldId, newId);
        }
        for (CMLAtom atom : atoms) {
            String oldId = atom.getId();
            atom.resetId((String)mapTable.get(oldId));
        }
        this.indexAtoms();
        for (CMLBond bond : this.getBonds()) {
            String[] atomRefs2 = bond.getAtomRefs2();
            String ar0 = (String)mapTable.get(atomRefs2[0]);
            String ar1 = (String)mapTable.get(atomRefs2[1]);
            bond.setAtomRefs2(ar0, ar1);
            bond.setId(bond.createId());
        }
        this.indexBonds();
    }

    public void roundCoords(double epsilon, CMLElement.CoordinateType coordinateType) {
        CMLElements<CMLMolecule> molecules = this.getMoleculeElements();
        if (molecules.size() > 0) {
            for (CMLMolecule molecule : molecules) {
                molecule.roundCoords(epsilon, coordinateType);
            }
        } else {
            for (CMLAtom atom : this.getAtoms()) {
                atom.roundCoords(epsilon, coordinateType);
            }
        }
    }

    public void setBondOrders(String order) {
        if (order != null) {
            for (CMLBond bond : this.getBonds()) {
                bond.setOrder(order);
            }
        }
    }

    public void setNormalizedBondOrders() {
        List<CMLBond> bonds = this.getBonds();
        for (CMLBond bond : bonds) {
            try {
                String order = bond.getOrder();
                if (order == null) continue;
                if (CMLBond.isSingle(order)) {
                    order = "S";
                } else if (CMLBond.isDouble(order)) {
                    order = "D";
                } else if (CMLBond.isTriple(order)) {
                    order = "T";
                }
                bond.setOrder(order);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("BUG " + e);
            }
        }
    }

    public void translate2D(Real2 delta2) {
        for (CMLAtom atom : this.getAtoms()) {
            if (!atom.hasCoordinates(CMLElement.CoordinateType.TWOD)) continue;
            atom.setX2(atom.getX2() + delta2.x);
            atom.setY2(atom.getY2() + delta2.y);
        }
    }

    public void unlabelAllAtoms() {
        for (CMLAtom atom : this.getAtoms()) {
            for (CMLLabel label : atom.getLabelElements()) {
                label.detach();
            }
        }
    }

    public void normalizeFormulas() {
        CMLFormula formula = new CMLFormula(this);
        String concise = formula.getConcise();
        Nodes formulaElements = this.query("./cml:formula", CML_XPATH);
        for (int i = 0; i < formulaElements.size(); ++i) {
            CMLFormula formulaElement = (CMLFormula)formulaElements.get(i);
            String conciseString = formulaElement.getConcise();
            if (conciseString == null) {
                formulaElement.setConcise(concise);
            } else if (!conciseString.equals(concise)) {
                throw new RuntimeException("incompatible concise formulae; was " + conciseString + "; now " + concise);
            }
            Nodes atomArrays = formulaElement.query("./cml:atomArray", CML_XPATH);
            for (int j = 0; j < atomArrays.size(); ++j) {
                atomArrays.get(j).detach();
            }
        }
    }

    public CMLFormula getFirstConciseFormula() {
        Nodes nodes = this.query("./*[local-name()='formula' and @concise]");
        return nodes.size() > 0 ? (CMLFormula)nodes.get(0) : null;
    }

    public String getFirstConciseFormulaString() {
        CMLFormula formula = this.getFirstConciseFormula();
        return formula == null ? null : formula.getConcise();
    }

    public void addName(String nameString) {
        CMLName name = new CMLName();
        name.setXMLContent(nameString);
        this.addName(name);
    }

    public int calculateHydrogenCount() {
        int totalImplicitHydrogenCount = 0;
        HashSet<CMLAtom> uniqueHydrogens = new HashSet<CMLAtom>();
        for (CMLAtom atom : this.getAtoms()) {
            List<CMLAtom> explicitHydrogens;
            int hydrogenCount = atom.getHydrogenCount();
            int implicitHydrogenCount = hydrogenCount - (explicitHydrogens = atom.getLigandHydrogenAtoms()).size();
            if (implicitHydrogenCount > 0) {
                totalImplicitHydrogenCount += implicitHydrogenCount;
            }
            uniqueHydrogens.addAll(explicitHydrogens);
        }
        return totalImplicitHydrogenCount + uniqueHydrogens.size();
    }

    static {
        logger.setLevel(Level.INFO);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HydrogenControl {
        ADD_TO_EXPLICIT_HYDROGENS,
        ADD_TO_HYDROGEN_COUNT,
        NO_EXPLICIT_HYDROGENS,
        REPLACE_HYDROGEN_COUNT,
        USE_EXPLICIT_HYDROGENS,
        USE_HYDROGEN_COUNT;

    }
}

