/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.RandomOrderIterator;

public class RandomOrderGraph
extends WrappedGraph {
    private final int bufsz;

    public static Graph createDefaultGraph() {
        return new RandomOrderGraph(Factory.createDefaultGraph());
    }

    public static Model createDefaultModel() {
        return ModelFactory.createModelForGraph(RandomOrderGraph.createDefaultGraph());
    }

    public RandomOrderGraph(int bufsz, Graph base) {
        super(base);
        this.bufsz = bufsz;
    }

    public RandomOrderGraph(Graph base) {
        this(10, base);
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch m) {
        return new RandomOrderIterator<Triple>(this.bufsz, super.find(m));
    }

    @Override
    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        return new RandomOrderIterator<Triple>(this.bufsz, super.find(s, p, o));
    }
}

