/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.fingerprint.SimpleAtomCanonicalizer;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortestPathWalker {
    private static final long serialVersionUID = 997363526L;
    private final IAtomContainer atomContainer;
    private final Set<String> cleanPath = new HashSet<String>();
    private final List<String> pseudoAtoms;
    private int pseduoAtomCounter;
    private final Set<StringBuilder> allPaths;

    public ShortestPathWalker(IAtomContainer atomContainer) {
        this.atomContainer = atomContainer;
        this.pseudoAtoms = new ArrayList<String>();
        this.pseduoAtomCounter = 0;
        this.allPaths = new HashSet<StringBuilder>();
        this.findPaths();
    }

    public Set<String> getPaths() {
        return Collections.unmodifiableSet(this.cleanPath);
    }

    public int getPathCount() {
        return this.cleanPath.size();
    }

    private void findPaths() {
        this.pseudoAtoms.clear();
        this.traverseShortestPaths();
        for (StringBuilder s : this.allPaths) {
            String clean = s.toString().trim();
            if (clean.isEmpty()) continue;
            this.cleanPath.add(clean);
        }
    }

    private void traverseShortestPaths() {
        Collection<IAtom> canonicalizeAtoms = new SimpleAtomCanonicalizer().canonicalizeAtoms(this.atomContainer);
        for (IAtom sourceAtom : canonicalizeAtoms) {
            StringBuilder sb = new StringBuilder();
            this.setAtom(sourceAtom, sb);
            if (!this.allPaths.contains(sb)) {
                this.allPaths.add(sb);
            }
            for (IAtom sinkAtom : canonicalizeAtoms) {
                List<IAtom> shortestPath;
                sb = new StringBuilder();
                if (sourceAtom == sinkAtom || (shortestPath = PathTools.getShortestPath(this.atomContainer, sourceAtom, sinkAtom)) == null || shortestPath.isEmpty() || shortestPath.size() < 2) continue;
                IAtom atomCurrent = shortestPath.get(0);
                for (int i = 1; i < shortestPath.size(); ++i) {
                    IAtom atomNext = shortestPath.get(i);
                    this.setAtom(atomCurrent, sb);
                    sb.append(this.getBondSymbol(this.atomContainer.getBond(atomCurrent, atomNext)));
                    atomCurrent = atomNext;
                }
                this.setAtom(atomCurrent, sb);
                this.allPaths.add(sb);
            }
        }
    }

    private void setAtom(IAtom atomCurrent, StringBuilder sb) {
        if (atomCurrent instanceof IPseudoAtom) {
            if (!this.pseudoAtoms.contains(atomCurrent.getSymbol())) {
                this.pseudoAtoms.add(this.pseduoAtomCounter, atomCurrent.getSymbol());
                ++this.pseduoAtomCounter;
            }
            sb.append((char)(PeriodicTable.getElementCount() + this.pseudoAtoms.indexOf(atomCurrent.getSymbol()) + 1));
        } else {
            Integer atnum = PeriodicTable.getAtomicNumber(atomCurrent.getSymbol());
            if (atnum != null) {
                sb.append(this.toAtomPattern(atomCurrent));
            } else {
                sb.append((char)PeriodicTable.getElementCount() + '\u0001');
            }
        }
    }

    private String toAtomPattern(IAtom atom) {
        return atom.getSymbol();
    }

    private char getBondSymbol(IBond bond) {
        if (this.isSP2Bond(bond)) {
            return '@';
        }
        switch (bond.getOrder()) {
            case SINGLE: {
                return '1';
            }
            case DOUBLE: {
                return '2';
            }
            case TRIPLE: {
                return '3';
            }
            case QUADRUPLE: {
                return '4';
            }
        }
        return '5';
    }

    private boolean isSP2Bond(IBond bond) {
        return bond.getFlag(32);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String path : this.cleanPath) {
            sb.append(path).append("->");
        }
        return sb.toString();
    }
}

